/*
 * Decompiled with CFR 0.152.
 */
package com.lassekoskela.time;

public class Clock {
    private static TimeSource timesource = new SystemClock();

    public static long now() {
        return timesource.now();
    }

    public static void freeze() {
        FakeClock fakeClock = new FakeClock(Clock.now());
        timesource = fakeClock;
    }

    public static void advance(long milliseconds) {
        timesource.advance(milliseconds);
    }

    public static void reset() {
        timesource = new SystemClock();
    }

    private static class FakeClock
    extends TimeSource {
        private long now;

        public FakeClock(long now) {
            this.now = now;
        }

        public long now() {
            return this.now;
        }

        public void advance(long milliseconds) throws UnsupportedOperationException {
            this.now += milliseconds;
        }
    }

    private static class SystemClock
    extends TimeSource {
        private SystemClock() {
        }

        public long now() {
            return System.currentTimeMillis();
        }
    }

    private static abstract class TimeSource {
        private TimeSource() {
        }

        public abstract long now();

        public void advance(long milliseconds) throws UnsupportedOperationException {
            String msg = "Advancing time is not supported by " + this.getClass().getName();
            throw new UnsupportedOperationException(msg);
        }
    }
}

