/*
 * Decompiled with CFR 0.152.
 */
package com.lassekoskela.time;

public class Duration {
    private static final int MILLIS_IN_HOUR = 3600000;
    private static final int MILLIS_IN_MINUTE = 60000;
    private static final int MILLIS_IN_SECOND = 1000;
    private long hours;
    private long minutes;
    private long seconds;
    private long millis;
    private final long inMilliseconds;

    public Duration(long milliseconds) {
        this.inMilliseconds = milliseconds;
        this.calculateTimeUnitsFrom(milliseconds);
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.inMilliseconds == ((Duration)obj).inMilliseconds;
    }

    private void calculateTimeUnitsFrom(long remainingMillis) {
        this.hours = remainingMillis / 3600000L;
        this.minutes = (remainingMillis -= this.hours * 3600000L) / 60000L;
        this.seconds = (remainingMillis -= this.minutes * 60000L) / 1000L;
        this.millis = remainingMillis -= this.seconds * 1000L;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.hours > 0L) {
            s.append(" ").append(this.hours).append("h");
        }
        if (this.minutes > 0L) {
            s.append(" ").append(this.minutes).append("m");
        }
        if (this.seconds > 0L) {
            s.append(" ").append(this.seconds).append("s");
        }
        if (this.millis > 0L) {
            s.append(" ").append(this.millis).append("ms");
        }
        return s.toString().trim();
    }

    public long inMillis() {
        return this.inMilliseconds;
    }

    public double inSeconds() {
        return (double)this.inMillis() / 1000.0;
    }

    public double percentageOf(long milliseconds) {
        return (double)this.inMillis() * 100.0 / (double)milliseconds;
    }

    public double percentageOf(Duration duration) {
        return this.percentageOf(duration.inMillis());
    }
}

