/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.batch;

import com.github.loki4j.client.batch.LogRecordStream;
import com.github.loki4j.client.util.StringUtils;

public class LogRecord {
    public final long timestampMs;
    public int nanos;
    public final LogRecordStream stream;
    public final String message;
    public final int messageUtf8SizeBytes;

    private LogRecord(long timestamp, int nanos, LogRecordStream stream, String message) {
        this.timestampMs = timestamp;
        this.nanos = nanos;
        this.stream = stream;
        this.message = message;
        this.messageUtf8SizeBytes = StringUtils.utf8Length(message);
    }

    public static LogRecord create(long timestamp, int nanos, LogRecordStream stream, String message) {
        return new LogRecord(timestamp, nanos, stream, message);
    }

    public String toString() {
        return "LogRecord [ts=" + this.timestampMs + ", stream=" + this.stream + ", message=" + this.message + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.stream == null ? 0 : this.stream.hashCode());
        result = 31 * result + (int)(this.timestampMs ^ this.timestampMs >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogRecord other = (LogRecord)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.stream == null ? other.stream != null : !this.stream.equals(other.stream)) {
            return false;
        }
        return this.timestampMs == other.timestampMs;
    }
}

