/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.spi.ContextAwareBase;
import com.github.loki4j.client.batch.LogRecordStream;
import com.github.loki4j.client.util.Cache;
import com.github.loki4j.client.util.StringUtils;
import com.github.loki4j.logback.Loki4jEncoder;
import com.github.loki4j.slf4j.marker.LabelMarker;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.slf4j.Marker;

public abstract class AbstractLoki4jEncoder
extends ContextAwareBase
implements Loki4jEncoder {
    private static final String REGEX_STARTER = "regex:";
    private static final String[] EMPTY_LABELS = new String[0];
    private static final String DEFAULT_MSG_PATTERN = "l=%level c=%logger{20} t=%thread | %msg %ex";
    protected final Charset charset = StandardCharsets.UTF_8;
    private final AtomicInteger nanoCounter = new AtomicInteger(0);
    private LabelCfg label = new LabelCfg();
    private boolean sortByTime = false;
    private volatile boolean staticLabels = false;
    private volatile long maxTimestampMs = 0L;
    private Pattern compiledLabelPairSeparator;
    private Pattern compiledLabelKeyValueSeparator;
    private PatternLayout labelPatternLayout;
    private Layout<ILoggingEvent> messageLayout;
    private LogRecordStream staticLabelStream = null;
    private boolean started = false;

    public void start() {
        String resolvedLblPat = this.label.pattern == null ? "level=%level,host=" + this.context.getProperty("HOSTNAME") : this.label.pattern;
        String labelPattern = this.label.nopex ? resolvedLblPat + "%nopex" : resolvedLblPat;
        this.compiledLabelPairSeparator = this.label.pairSeparator.startsWith(REGEX_STARTER) ? Pattern.compile(this.label.pairSeparator.substring(REGEX_STARTER.length())) : Pattern.compile(Pattern.quote(this.label.pairSeparator));
        this.compiledLabelKeyValueSeparator = Pattern.compile(Pattern.quote(this.label.keyValueSeparator));
        if (this.label.streamCache == null) {
            this.label.streamCache = new Cache.BoundAtomicMapCache<String, LogRecordStream>();
        }
        this.labelPatternLayout = this.initPatternLayout(labelPattern);
        this.labelPatternLayout.setContext(this.context);
        this.labelPatternLayout.start();
        if (this.messageLayout == null) {
            this.addWarn("No message layout specified in the config. Using PatternLayout with default settings");
            this.messageLayout = this.initPatternLayout(DEFAULT_MSG_PATTERN);
        }
        this.messageLayout.setContext(this.context);
        this.messageLayout.start();
        this.started = true;
    }

    public void stop() {
        this.started = false;
        this.messageLayout.stop();
        this.labelPatternLayout.stop();
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public LogRecordStream eventToStream(ILoggingEvent e) {
        String renderedLayout;
        if (this.staticLabels) {
            if (this.staticLabelStream == null) {
                this.staticLabelStream = LogRecordStream.create(this.extractStreamKVPairs(this.labelPatternLayout.doLayout(e)));
            }
            return this.staticLabelStream;
        }
        String streamKey = renderedLayout = this.labelPatternLayout.doLayout(e).intern();
        Object[] markerLabelsVar = EMPTY_LABELS;
        if (this.label.readMarkers && e.getMarkerList() != null) {
            for (Marker marker : e.getMarkerList()) {
                if (marker == null || !(marker instanceof LabelMarker)) continue;
                markerLabelsVar = this.extractLabelsFromMarker((LabelMarker)marker);
                streamKey = streamKey + "!markers!" + Arrays.toString(markerLabelsVar);
                break;
            }
        }
        Object[] markerLabels = markerLabelsVar;
        return this.label.streamCache.get(streamKey, () -> this.lambda$eventToStream$0(renderedLayout, (String[])markerLabels));
    }

    @Override
    public String eventToMessage(ILoggingEvent e) {
        return this.messageLayout.doLayout((Object)e);
    }

    @Override
    public int timestampToNanos(long timestampMs) {
        long nextMs = timestampMs % 1000L;
        if (this.maxTimestampMs > timestampMs) {
            return (int)nextMs * 1000 + 999;
        }
        int nanos = this.nanoCounter.updateAndGet(i -> {
            if (this.maxTimestampMs == timestampMs) {
                if (i % 1000 < 999) {
                    return i + 1;
                }
                return i;
            }
            return (int)nextMs * 1000;
        });
        this.maxTimestampMs = timestampMs;
        return nanos;
    }

    private PatternLayout initPatternLayout(String pattern) {
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setPattern(pattern);
        return patternLayout;
    }

    String[] extractStreamKVPairs(String stream) {
        String[] pairs = this.compiledLabelPairSeparator.split(stream);
        String[] result = new String[pairs.length * 2];
        int pos = 0;
        for (int i = 0; i < pairs.length; ++i) {
            if (StringUtils.isBlank(pairs[i])) continue;
            String[] kv = this.compiledLabelKeyValueSeparator.split(pairs[i]);
            if (kv.length == 2) {
                result[pos] = kv[0];
                result[pos + 1] = kv[1];
                pos += 2;
                continue;
            }
            throw new IllegalArgumentException(String.format("Unable to split '%s' in '%s' to label key-value pairs, pairSeparator=%s, keyValueSeparator=%s", pairs[i], stream, this.label.pairSeparator, this.label.keyValueSeparator));
        }
        return Arrays.copyOf(result, pos);
    }

    String[] extractLabelsFromMarker(LabelMarker marker) {
        Map<String, String> labelMap = marker.getLabels();
        String[] markerLabels = new String[labelMap.size() * 2];
        int pos = 0;
        for (Map.Entry<String, String> entry : labelMap.entrySet()) {
            markerLabels[pos] = entry.getKey();
            markerLabels[pos + 1] = entry.getValue();
            pos += 2;
        }
        return markerLabels;
    }

    public LabelCfg getLabel() {
        return this.label;
    }

    public void setLabel(LabelCfg label) {
        this.label = label;
    }

    @DefaultClass(value=PatternLayout.class)
    public void setMessage(Layout<ILoggingEvent> message) {
        this.messageLayout = message;
    }

    @Override
    public boolean getSortByTime() {
        return this.sortByTime;
    }

    public void setSortByTime(boolean sortByTime) {
        this.sortByTime = sortByTime;
    }

    @Override
    public boolean getStaticLabels() {
        return this.staticLabels;
    }

    public void setStaticLabels(boolean staticLabels) {
        this.staticLabels = staticLabels;
    }

    private /* synthetic */ LogRecordStream lambda$eventToStream$0(String renderedLayout, String[] markerLabels) {
        String[] layoutLabels = this.extractStreamKVPairs(renderedLayout);
        if (markerLabels == EMPTY_LABELS) {
            return LogRecordStream.create(layoutLabels);
        }
        String[] allLabels = Arrays.copyOf(layoutLabels, layoutLabels.length + markerLabels.length);
        System.arraycopy(markerLabels, 0, allLabels, layoutLabels.length, markerLabels.length);
        return LogRecordStream.create(allLabels);
    }

    public static final class LabelCfg {
        String pattern;
        String pairSeparator = ",";
        String keyValueSeparator = "=";
        boolean readMarkers = false;
        boolean nopex = true;
        Cache<String, LogRecordStream> streamCache;

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setKeyValueSeparator(String keyValueSeparator) {
            this.keyValueSeparator = keyValueSeparator;
        }

        public void setPairSeparator(String pairSeparator) {
            this.pairSeparator = pairSeparator;
        }

        public void setReadMarkers(boolean readMarkers) {
            this.readMarkers = readMarkers;
        }

        public void setNopex(boolean nopex) {
            this.nopex = nopex;
        }

        @DefaultClass(value=Cache.BoundAtomicMapCache.class)
        public void setStreamCache(Cache<String, LogRecordStream> streamCache) {
            this.streamCache = streamCache;
        }
    }
}

