/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import com.github.loki4j.client.util.Loki4jLogger;

public class InternalLogger
implements Loki4jLogger {
    private final Object source;
    private final ContextAware logger;

    public InternalLogger(Object source, ContextAware logger) {
        this.source = source;
        this.logger = logger;
    }

    @Override
    public void trace(String msg, Object ... args) {
        if (this.isTraceEnabled(this.source)) {
            this.logger.addStatus((Status)new InfoStatus(String.format(msg, args), this.source));
        }
    }

    @Override
    public void info(String msg, Object ... args) {
        this.logger.addStatus((Status)new InfoStatus(String.format(msg, args), this.source));
    }

    @Override
    public void warn(String msg, Object ... args) {
        this.logger.addStatus((Status)new WarnStatus(String.format(msg, args), this.source));
    }

    @Override
    public void error(String msg, Object ... args) {
        this.logger.addStatus((Status)new ErrorStatus(String.format(msg, args), this.source));
    }

    @Override
    public void error(Throwable ex, String msg, Object ... args) {
        this.logger.addStatus((Status)new ErrorStatus(String.format(msg, args), this.source, ex));
    }
}

