/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback.json;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.github.loki4j.logback.json.AbstractFieldJsonProvider;
import com.github.loki4j.logback.json.JsonEventWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MdcJsonProvider
extends AbstractFieldJsonProvider {
    public static final String FIELD_MDC_PREFIX = "mdc_";
    private Set<String> excludeKeys = new HashSet<String>();
    private Set<String> includeKeys = new HashSet<String>();

    public MdcJsonProvider() {
        this.setFieldName(FIELD_MDC_PREFIX);
    }

    @Override
    public boolean canWrite(ILoggingEvent event) {
        Map mdcProperties = event.getMDCPropertyMap();
        return mdcProperties != null && !mdcProperties.isEmpty();
    }

    @Override
    public boolean writeTo(JsonEventWriter writer, ILoggingEvent event, boolean startWithSeparator) {
        Map mdcProperties = event.getMDCPropertyMap();
        boolean firstFieldWritten = false;
        for (Map.Entry entry : mdcProperties.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || !this.excludeKeys.isEmpty() && this.excludeKeys.contains(entry.getKey()) || !this.includeKeys.isEmpty() && !this.includeKeys.contains(entry.getKey())) continue;
            if (startWithSeparator || firstFieldWritten) {
                writer.writeFieldSeparator();
            }
            writer.writeStringField(this.getFieldName() + (String)entry.getKey(), (String)entry.getValue());
            firstFieldWritten = true;
        }
        return firstFieldWritten;
    }

    @Override
    protected void writeExactlyOneField(JsonEventWriter writer, ILoggingEvent event) {
        throw new UnsupportedOperationException("MdcJsonProvider can write an arbitrary number of fields. `writeExactlyOneField` should never be called for MdcJsonProvider.");
    }

    public void addExclude(String key) {
        this.excludeKeys.add(key);
    }

    public void addInclude(String key) {
        this.includeKeys.add(key);
    }
}

