/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker;

import com.github.ltsopensource.autoconfigure.PropertiesConfigurationFactory;
import com.github.ltsopensource.core.cluster.AbstractNodeBuilder;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.properties.JobTrackerProperties;
import com.github.ltsopensource.jobtracker.JobTracker;
import java.util.Map;

public class JobTrackerBuilder
extends AbstractNodeBuilder<JobTracker, JobTrackerBuilder> {
    protected JobTracker build0() {
        JobTrackerProperties properties = (JobTrackerProperties)PropertiesConfigurationFactory.createPropertiesConfiguration(JobTrackerProperties.class, (String[])this.locations);
        return JobTrackerBuilder.buildByProperties(properties);
    }

    public static JobTracker buildByProperties(JobTrackerProperties properties) {
        properties.checkProperties();
        JobTracker jobTracker = new JobTracker();
        jobTracker.setRegistryAddress(properties.getRegistryAddress());
        if (StringUtils.isNotEmpty((String[])new String[]{properties.getClusterName()})) {
            jobTracker.setClusterName(properties.getClusterName());
        }
        if (properties.getListenPort() != null) {
            jobTracker.setListenPort(properties.getListenPort());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{properties.getIdentity()})) {
            jobTracker.setIdentity(properties.getIdentity());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{properties.getBindIp()})) {
            jobTracker.setBindIp(properties.getBindIp());
        }
        if (CollectionUtils.isNotEmpty((Map)properties.getConfigs())) {
            for (Map.Entry entry : properties.getConfigs().entrySet()) {
                jobTracker.addConfig((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return jobTracker;
    }
}

