/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.cmd;

import com.github.ltsopensource.cmd.HttpCmdProc;
import com.github.ltsopensource.cmd.HttpCmdRequest;
import com.github.ltsopensource.cmd.HttpCmdResponse;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;

public class LoadJobHttpCmd
implements HttpCmdProc {
    private final Logger LOGGER = LoggerFactory.getLogger(LoadJobHttpCmd.class);
    private JobTrackerAppContext appContext;

    public LoadJobHttpCmd(JobTrackerAppContext appContext) {
        this.appContext = appContext;
    }

    public String nodeIdentity() {
        return this.appContext.getConfig().getIdentity();
    }

    public String getCommand() {
        return "job_load_cmd";
    }

    public HttpCmdResponse execute(HttpCmdRequest request) throws Exception {
        String taskTrackerNodeGroup = request.getParam("nodeGroup");
        this.appContext.getPreLoader().load(taskTrackerNodeGroup);
        this.LOGGER.info("load job succeed : nodeGroup={}", new Object[]{taskTrackerNodeGroup});
        return HttpCmdResponse.newResponse((boolean)true, (String)"load job succeed");
    }
}

