/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.complete;

import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.domain.JobMeta;
import com.github.ltsopensource.core.domain.JobRunResult;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.CronExpressionUtils;
import com.github.ltsopensource.core.support.JobUtils;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import java.util.Date;
import java.util.List;

public class JobRetryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRetryHandler.class);
    private JobTrackerAppContext appContext;
    private long retryInterval = 30000L;

    public JobRetryHandler(JobTrackerAppContext appContext) {
        this.appContext = appContext;
        this.retryInterval = appContext.getConfig().getParameter("jobtracker.job.retry.interval.millis", 30000);
    }

    public void onComplete(List<JobRunResult> results) {
        if (CollectionUtils.isEmpty(results)) {
            return;
        }
        for (JobRunResult result : results) {
            JobMeta jobMeta = result.getJobMeta();
            JobPo jobPo = this.appContext.getExecutingJobQueue().getJob(jobMeta.getJobId());
            if (jobPo == null) continue;
            jobPo.setRetryTimes(Integer.valueOf((jobPo.getRetryTimes() == null ? 0 : jobPo.getRetryTimes()) + 1));
            Long nextRetryTriggerTime = SystemClock.now() + this.retryInterval;
            if (jobPo.isCron()) {
                JobPo cronJobPo = this.appContext.getCronJobQueue().getJob(jobMeta.getJobId());
                if (cronJobPo != null) {
                    Date nextTriggerTime = CronExpressionUtils.getNextTriggerTime((String)cronJobPo.getCronExpression());
                    if (nextTriggerTime != null && nextTriggerTime.getTime() < nextRetryTriggerTime) {
                        nextRetryTriggerTime = nextTriggerTime.getTime();
                        jobPo = cronJobPo;
                    } else {
                        jobPo.setInternalExtParam("__LTS_Is_Retry_Job", Boolean.TRUE.toString());
                    }
                }
            } else if (jobPo.isRepeatable()) {
                JobPo repeatJobPo = this.appContext.getRepeatJobQueue().getJob(jobMeta.getJobId());
                if (repeatJobPo != null && (repeatJobPo.getRepeatCount() == -1 || repeatJobPo.getRepeatedCount() < repeatJobPo.getRepeatCount())) {
                    long nexTriggerTime = JobUtils.getRepeatNextTriggerTime((JobPo)jobPo);
                    if (nexTriggerTime < nextRetryTriggerTime) {
                        nextRetryTriggerTime = nexTriggerTime;
                        jobPo = repeatJobPo;
                    } else {
                        jobPo.setInternalExtParam("__LTS_Is_Retry_Job", Boolean.TRUE.toString());
                    }
                }
            } else {
                jobPo.setInternalExtParam("__LTS_Is_Retry_Job", Boolean.TRUE.toString());
            }
            jobPo.setTaskTrackerIdentity(null);
            jobPo.setIsRunning(Boolean.valueOf(false));
            jobPo.setGmtModified(Long.valueOf(SystemClock.now()));
            jobPo.setTriggerTime(nextRetryTriggerTime);
            try {
                this.appContext.getExecutableJobQueue().add(jobPo);
            }
            catch (DupEntryException e) {
                LOGGER.warn("ExecutableJobQueue already exist:" + JSON.toJSONString((Object)jobPo));
            }
            this.appContext.getExecutingJobQueue().remove(jobPo.getJobId());
        }
    }
}

