/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.complete.biz;

import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.domain.Action;
import com.github.ltsopensource.core.domain.Job;
import com.github.ltsopensource.core.domain.JobRunResult;
import com.github.ltsopensource.core.protocol.command.JobCompletedRequest;
import com.github.ltsopensource.core.support.JobDomainConverter;
import com.github.ltsopensource.jobtracker.complete.JobFinishHandler;
import com.github.ltsopensource.jobtracker.complete.JobRetryHandler;
import com.github.ltsopensource.jobtracker.complete.biz.JobCompletedBiz;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.support.ClientNotifier;
import com.github.ltsopensource.jobtracker.support.ClientNotifyHandler;
import com.github.ltsopensource.queue.domain.JobFeedbackPo;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JobProcBiz
implements JobCompletedBiz {
    private ClientNotifier clientNotifier;
    private final JobRetryHandler retryHandler;
    private final JobFinishHandler jobFinishHandler;
    private final Integer globalMaxRetryTimes;

    public JobProcBiz(final JobTrackerAppContext appContext) {
        this.retryHandler = new JobRetryHandler(appContext);
        this.jobFinishHandler = new JobFinishHandler(appContext);
        this.globalMaxRetryTimes = appContext.getConfig().getParameter("job.max.retry.times", 10);
        this.clientNotifier = new ClientNotifier(appContext, new ClientNotifyHandler<JobRunResult>(){

            @Override
            public void handleSuccess(List<JobRunResult> results) {
                JobProcBiz.this.jobFinishHandler.onComplete(results);
            }

            @Override
            public void handleFailed(List<JobRunResult> results) {
                if (CollectionUtils.isNotEmpty(results)) {
                    ArrayList<JobFeedbackPo> jobFeedbackPos = new ArrayList<JobFeedbackPo>(results.size());
                    for (JobRunResult result : results) {
                        JobFeedbackPo jobFeedbackPo = JobDomainConverter.convert((JobRunResult)result);
                        jobFeedbackPos.add(jobFeedbackPo);
                    }
                    appContext.getJobFeedbackQueue().add(jobFeedbackPos);
                    JobProcBiz.this.jobFinishHandler.onComplete(results);
                }
            }
        });
    }

    @Override
    public RemotingCommand doBiz(JobCompletedRequest request) {
        List results = request.getJobRunResults();
        if (CollectionUtils.sizeOf((Collection)results) == 1) {
            this.singleResultsProcess(results);
        } else {
            this.multiResultsProcess(results);
        }
        return null;
    }

    private void singleResultsProcess(List<JobRunResult> results) {
        JobRunResult result = results.get(0);
        if (!this.needRetry(result)) {
            if (this.isNeedFeedback(result.getJobMeta().getJob())) {
                this.clientNotifier.send(results);
            } else {
                this.jobFinishHandler.onComplete(results);
            }
        } else {
            this.retryHandler.onComplete(results);
        }
    }

    private boolean needRetry(JobRunResult result) {
        if (!Action.EXECUTE_LATER.equals((Object)result.getAction()) && !Action.EXECUTE_EXCEPTION.equals((Object)result.getAction())) {
            return false;
        }
        Job job = result.getJobMeta().getJob();
        Integer retryTimes = result.getJobMeta().getRetryTimes();
        int jobMaxRetryTimes = job.getMaxRetryTimes();
        return retryTimes < this.globalMaxRetryTimes && retryTimes < jobMaxRetryTimes;
    }

    private void multiResultsProcess(List<JobRunResult> results) {
        List retryResults = null;
        List feedbackResults = null;
        List finishResults = null;
        for (JobRunResult result : results) {
            if (this.needRetry(result)) {
                retryResults = CollectionUtils.newArrayListOnNull(retryResults);
                retryResults.add(result);
                continue;
            }
            if (this.isNeedFeedback(result.getJobMeta().getJob())) {
                feedbackResults = CollectionUtils.newArrayListOnNull(feedbackResults);
                feedbackResults.add(result);
                continue;
            }
            finishResults = CollectionUtils.newArrayListOnNull(finishResults);
            finishResults.add(result);
        }
        this.clientNotifier.send(feedbackResults);
        this.jobFinishHandler.onComplete(finishResults);
        this.retryHandler.onComplete(retryResults);
    }

    private boolean isNeedFeedback(Job job) {
        if (job == null) {
            return false;
        }
        return !StringUtils.isEmpty((String)job.getSubmitNodeGroup()) && job.isNeedFeedback();
    }
}

