/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.complete.biz;

import com.github.ltsopensource.core.protocol.command.AbstractRemotingCommandBody;
import com.github.ltsopensource.core.protocol.command.JobCompletedRequest;
import com.github.ltsopensource.core.protocol.command.JobPushRequest;
import com.github.ltsopensource.core.support.JobDomainConverter;
import com.github.ltsopensource.jobtracker.complete.biz.JobCompletedBiz;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.sender.JobSender;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.remoting.RemotingCommandBody;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import com.github.ltsopensource.remoting.protocol.RemotingProtos;

public class PushNewJobBiz
implements JobCompletedBiz {
    private JobTrackerAppContext appContext;

    public PushNewJobBiz(JobTrackerAppContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public RemotingCommand doBiz(JobCompletedRequest request) {
        if (request.isReceiveNewJob()) {
            try {
                JobPushRequest jobPushRequest = this.getNewJob(request.getNodeGroup(), request.getIdentity());
                return RemotingCommand.createResponseCommand((int)RemotingProtos.ResponseCode.SUCCESS.code(), (RemotingCommandBody)jobPushRequest);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private JobPushRequest getNewJob(String taskTrackerNodeGroup, String taskTrackerIdentity) {
        JobSender.SendResult sendResult = this.appContext.getJobSender().send(taskTrackerNodeGroup, taskTrackerIdentity, new JobSender.SendInvoker(){

            @Override
            public JobSender.SendResult invoke(JobPo jobPo) {
                JobPushRequest jobPushRequest = (JobPushRequest)PushNewJobBiz.this.appContext.getCommandBodyWrapper().wrapper((AbstractRemotingCommandBody)new JobPushRequest());
                jobPushRequest.setJobMeta(JobDomainConverter.convert((JobPo)jobPo));
                return new JobSender.SendResult(true, jobPushRequest);
            }
        });
        if (sendResult.isSuccess()) {
            return (JobPushRequest)sendResult.getReturnValue();
        }
        return null;
    }
}

