/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.monitor;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.domain.monitor.JobTrackerMData;
import com.github.ltsopensource.core.domain.monitor.MData;
import com.github.ltsopensource.core.monitor.AbstractMStatReporter;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import java.util.concurrent.atomic.AtomicLong;

public class JobTrackerMStatReporter
extends AbstractMStatReporter {
    private AtomicLong receiveJobNum = new AtomicLong(0L);
    private AtomicLong pushJobNum = new AtomicLong(0L);
    private AtomicLong exeSuccessNum = new AtomicLong(0L);
    private AtomicLong exeFailedNum = new AtomicLong(0L);
    private AtomicLong exeLaterNum = new AtomicLong(0L);
    private AtomicLong exeExceptionNum = new AtomicLong(0L);
    private AtomicLong fixExecutingJobNum = new AtomicLong(0L);

    public JobTrackerMStatReporter(JobTrackerAppContext appContext) {
        super((AppContext)appContext);
    }

    public void incReceiveJobNum() {
        this.receiveJobNum.incrementAndGet();
    }

    public void incPushJobNum() {
        this.pushJobNum.incrementAndGet();
    }

    public void incExeSuccessNum() {
        this.exeSuccessNum.incrementAndGet();
    }

    public void incExeFailedNum() {
        this.exeFailedNum.incrementAndGet();
    }

    public void incExeLaterNum() {
        this.exeLaterNum.incrementAndGet();
    }

    public void incExeExceptionNum() {
        this.exeExceptionNum.incrementAndGet();
    }

    public void incFixExecutingJobNum() {
        this.fixExecutingJobNum.incrementAndGet();
    }

    protected MData collectMData() {
        JobTrackerMData mData = new JobTrackerMData();
        mData.setReceiveJobNum(Long.valueOf(this.receiveJobNum.getAndSet(0L)));
        mData.setExeExceptionNum(Long.valueOf(this.exeExceptionNum.getAndSet(0L)));
        mData.setExeFailedNum(Long.valueOf(this.exeFailedNum.getAndSet(0L)));
        mData.setExeSuccessNum(Long.valueOf(this.exeSuccessNum.getAndSet(0L)));
        mData.setExeLaterNum(Long.valueOf(this.exeLaterNum.getAndSet(0L)));
        mData.setFixExecutingJobNum(Long.valueOf(this.fixExecutingJobNum.getAndSet(0L)));
        mData.setPushJobNum(Long.valueOf(this.pushJobNum.getAndSet(0L)));
        return mData;
    }

    protected NodeType getNodeType() {
        return NodeType.JOB_TRACKER;
    }
}

