/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.processor;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.protocol.JobProtos;
import com.github.ltsopensource.core.protocol.command.JobPullRequest;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.processor.AbstractRemotingProcessor;
import com.github.ltsopensource.jobtracker.support.JobPusher;
import com.github.ltsopensource.remoting.Channel;
import com.github.ltsopensource.remoting.exception.RemotingCommandException;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;

public class JobPullProcessor
extends AbstractRemotingProcessor {
    private JobPusher jobPusher;
    private static final Logger LOGGER = LoggerFactory.getLogger(JobPullProcessor.class);

    public JobPullProcessor(JobTrackerAppContext appContext) {
        super(appContext);
        this.jobPusher = new JobPusher(appContext);
    }

    public RemotingCommand processRequest(Channel ctx, RemotingCommand request) throws RemotingCommandException {
        JobPullRequest requestBody = (JobPullRequest)request.getBody();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("taskTrackerNodeGroup:{}, taskTrackerIdentity:{} , availableThreads:{}", new Object[]{requestBody.getNodeGroup(), requestBody.getIdentity(), requestBody.getAvailableThreads()});
        }
        this.jobPusher.concurrentPush(requestBody);
        return RemotingCommand.createResponseCommand((int)JobProtos.ResponseCode.JOB_PULL_SUCCESS.code(), (String)"");
    }
}

