/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.support.checker;

import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.queue.domain.JobPo;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExecutableDeadJobChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutableDeadJobChecker.class);
    private static final long MAX_TIME_OUT = 60000L;
    private final ScheduledExecutorService FIXED_EXECUTOR_SERVICE = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("LTS-ExecutableJobQueue-Fix-Executor", true));
    private JobTrackerAppContext appContext;
    private AtomicBoolean start = new AtomicBoolean(false);
    private ScheduledFuture<?> scheduledFuture;

    public ExecutableDeadJobChecker(JobTrackerAppContext appContext) {
        this.appContext = appContext;
    }

    public void start() {
        try {
            if (this.start.compareAndSet(false, true)) {
                this.scheduledFuture = this.FIXED_EXECUTOR_SERVICE.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!ExecutableDeadJobChecker.this.appContext.getRegistryStatMonitor().isAvailable()) {
                                return;
                            }
                            ExecutableDeadJobChecker.this.fix();
                        }
                        catch (Throwable t) {
                            LOGGER.error(t.getMessage(), t);
                        }
                    }
                }, 30L, 60L, TimeUnit.SECONDS);
            }
            LOGGER.info("Executable dead job checker started!");
        }
        catch (Throwable t) {
            LOGGER.info("Executable dead job checker start failed!");
        }
    }

    private void fix() {
        Set<String> nodeGroups = this.appContext.getTaskTrackerManager().getNodeGroups();
        if (CollectionUtils.isEmpty(nodeGroups)) {
            return;
        }
        for (String nodeGroup : nodeGroups) {
            List deadJobPo = this.appContext.getExecutableJobQueue().getDeadJob(nodeGroup, SystemClock.now() - 60000L);
            if (!CollectionUtils.isNotEmpty((Collection)deadJobPo)) continue;
            for (JobPo jobPo : deadJobPo) {
                this.appContext.getExecutableJobQueue().resume(jobPo);
                LOGGER.info("Fix executable job : {} ", new Object[]{JSON.toJSONString((Object)jobPo)});
            }
        }
    }

    public void stop() {
        try {
            if (this.start.compareAndSet(true, false)) {
                this.scheduledFuture.cancel(true);
                this.FIXED_EXECUTOR_SERVICE.shutdown();
            }
            LOGGER.info("Executable dead job checker stopped!");
        }
        catch (Throwable t) {
            LOGGER.error("Executable dead job checker stop failed!", t);
        }
    }
}

