/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.support.checker;

import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.domain.JobRunResult;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.jobtracker.domain.JobClientNode;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.support.ClientNotifier;
import com.github.ltsopensource.jobtracker.support.ClientNotifyHandler;
import com.github.ltsopensource.queue.domain.JobFeedbackPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class FeedbackJobSendChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackJobSendChecker.class);
    private ScheduledExecutorService RETRY_EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("LTS-FeedbackJobSend-Executor", true));
    private ScheduledFuture<?> scheduledFuture;
    private AtomicBoolean start = new AtomicBoolean(false);
    private ClientNotifier clientNotifier;
    private JobTrackerAppContext appContext;
    private volatile boolean isRunning = false;

    private boolean isStart() {
        return this.start.get();
    }

    public FeedbackJobSendChecker(final JobTrackerAppContext appContext) {
        this.appContext = appContext;
        this.clientNotifier = new ClientNotifier(appContext, new ClientNotifyHandler<JobRunResultWrapper>(){

            @Override
            public void handleSuccess(List<JobRunResultWrapper> jobResults) {
                for (JobRunResultWrapper jobResult : jobResults) {
                    String submitNodeGroup = jobResult.getJobMeta().getJob().getSubmitNodeGroup();
                    appContext.getJobFeedbackQueue().remove(submitNodeGroup, jobResult.getId());
                }
            }

            @Override
            public void handleFailed(List<JobRunResultWrapper> jobResults) {
            }
        });
    }

    public void start() {
        try {
            if (this.start.compareAndSet(false, true)) {
                this.scheduledFuture = this.RETRY_EXECUTOR_SERVICE.scheduleWithFixedDelay(new Runner(), 30L, 30L, TimeUnit.SECONDS);
            }
            LOGGER.info("Feedback job checker started!");
        }
        catch (Throwable t) {
            LOGGER.error("Feedback job checker start failed!", t);
        }
    }

    public void stop() {
        try {
            if (this.start.compareAndSet(true, false)) {
                this.scheduledFuture.cancel(true);
                this.RETRY_EXECUTOR_SERVICE.shutdown();
                LOGGER.info("Feedback job checker stopped!");
            }
        }
        catch (Throwable t) {
            LOGGER.error("Feedback job checker stop failed!", t);
        }
    }

    private class JobRunResultWrapper
    extends JobRunResult {
        private static final long serialVersionUID = 6257259684477618571L;
        private String id;

        public String getId() {
            return this.id;
        }

        public JobRunResultWrapper(String id, JobRunResult result) {
            this.id = id;
            this.setJobMeta(result.getJobMeta());
            this.setMsg(result.getMsg());
            this.setAction(result.getAction());
            this.setTime(result.getTime());
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!FeedbackJobSendChecker.this.appContext.getRegistryStatMonitor().isAvailable()) {
                    return;
                }
                if (FeedbackJobSendChecker.this.isRunning) {
                    return;
                }
                FeedbackJobSendChecker.this.isRunning = true;
                Set<String> taskTrackerNodeGroups = FeedbackJobSendChecker.this.appContext.getJobClientManager().getNodeGroups();
                if (CollectionUtils.isEmpty(taskTrackerNodeGroups)) {
                    return;
                }
                for (String taskTrackerNodeGroup : taskTrackerNodeGroups) {
                    this.check(taskTrackerNodeGroup);
                }
            }
            catch (Throwable t) {
                LOGGER.error(t.getMessage(), t);
            }
            finally {
                FeedbackJobSendChecker.this.isRunning = false;
            }
        }

        private void check(String jobClientNodeGroup) {
            List jobFeedbackPos;
            JobClientNode jobClientNode = FeedbackJobSendChecker.this.appContext.getJobClientManager().getAvailableJobClient(jobClientNodeGroup);
            if (jobClientNode == null) {
                return;
            }
            long count = FeedbackJobSendChecker.this.appContext.getJobFeedbackQueue().getCount(jobClientNodeGroup);
            if (count == 0L) {
                return;
            }
            LOGGER.info("{} jobs need to feedback.", new Object[]{count});
            int limit = 5;
            do {
                if (CollectionUtils.isEmpty((Collection)(jobFeedbackPos = FeedbackJobSendChecker.this.appContext.getJobFeedbackQueue().fetchTop(jobClientNodeGroup, limit)))) {
                    return;
                }
                ArrayList<JobRunResultWrapper> jobResults = new ArrayList<JobRunResultWrapper>(jobFeedbackPos.size());
                for (JobFeedbackPo jobFeedbackPo : jobFeedbackPos) {
                    if (FeedbackJobSendChecker.this.appContext.getOldDataHandler() != null && FeedbackJobSendChecker.this.appContext.getOldDataHandler().handle(FeedbackJobSendChecker.this.appContext.getJobFeedbackQueue(), jobFeedbackPo, jobFeedbackPo)) continue;
                    jobResults.add(new JobRunResultWrapper(jobFeedbackPo.getId(), jobFeedbackPo.getJobRunResult()));
                }
                int sentSize = FeedbackJobSendChecker.this.clientNotifier.send(jobResults);
                LOGGER.info("Send to client: {} success, {} failed.", new Object[]{sentSize, jobResults.size() - sentSize});
            } while (jobFeedbackPos.size() > 0);
        }
    }
}

