/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.support.listener;

import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.listener.NodeChangeListener;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import java.util.List;

public class JobNodeChangeListener
implements NodeChangeListener {
    private JobTrackerAppContext appContext;

    public JobNodeChangeListener(JobTrackerAppContext appContext) {
        this.appContext = appContext;
    }

    public void addNodes(List<Node> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        for (Node node : nodes) {
            if (node.getNodeType().equals((Object)NodeType.TASK_TRACKER)) {
                this.appContext.getTaskTrackerManager().addNode(node);
                continue;
            }
            if (!node.getNodeType().equals((Object)NodeType.JOB_CLIENT)) continue;
            this.appContext.getJobClientManager().addNode(node);
        }
    }

    public void removeNodes(List<Node> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        for (Node node : nodes) {
            if (node.getNodeType().equals((Object)NodeType.TASK_TRACKER)) {
                this.appContext.getTaskTrackerManager().removeNode(node);
                continue;
            }
            if (!node.getNodeType().equals((Object)NodeType.JOB_CLIENT)) continue;
            this.appContext.getJobClientManager().removeNode(node);
        }
    }
}

