/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdInputStreamV04;
import com.github.luben.zstd.ZstdInputStreamV05;
import com.github.luben.zstd.util.Native;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class ZstdInputStream
extends FilterInputStream {
    private long ctx;
    private int blockSize = -1;
    private int oBuffSize = -1;
    private ByteBuffer oBuff = null;
    private int oPos = 0;
    private int oEnd = 0;
    private byte[] iBuff = null;
    private static final int MAGIC_BASE = -47205088;
    private FilterInputStream legacy = null;

    private static native long createDCtx();

    private static native int decompressBegin(long var0);

    private static native int freeDCtx(long var0);

    private static native int findBlockSize(byte[] var0, long var1);

    private static native int findOBuffSize(byte[] var0, long var1);

    private static native int nextSrcSizeToDecompress(long var0);

    private static native int decompressContinue(long var0, ByteBuffer var2, long var3, long var5, byte[] var7, long var8, long var10);

    public ZstdInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        int n;
        byte[] byArray = new byte[Zstd.frameHeaderSizeMax()];
        if (byArray == null) {
            throw new IOException("Error allocating the frame header buffer of size " + Zstd.frameHeaderSizeMax());
        }
        for (n = 0; n < 4; n += this.in.read(byArray, n, 4 - n)) {
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, 4);
        int n2 = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN).getInt() - -47205088;
        switch (n2) {
            case 6: {
                this.init(inputStream, byArray, n);
                break;
            }
            case 5: {
                this.legacy = new ZstdInputStreamV05(inputStream, byArray, n);
                break;
            }
            case 4: {
                this.legacy = new ZstdInputStreamV04(inputStream, byArray, n);
                break;
            }
            default: {
                throw new IOException("Legacy version " + n2 + " is not supported");
            }
        }
    }

    private void init(InputStream inputStream, byte[] byArray, int n) throws IOException {
        int n2;
        this.ctx = ZstdInputStream.createDCtx();
        ZstdInputStream.decompressBegin(this.ctx);
        while (this.blockSize < 0) {
            this.blockSize = ZstdInputStream.findBlockSize(byArray, n);
            if (this.blockSize >= 0) continue;
            n += this.in.read(byArray, n, -this.blockSize - n);
        }
        this.iBuff = new byte[this.blockSize];
        if (this.iBuff == null) {
            throw new IOException("Error allocating the input buffer of size " + this.blockSize);
        }
        while (this.oBuffSize < 0) {
            this.oBuffSize = ZstdInputStream.findOBuffSize(byArray, n);
            if (this.oBuffSize >= 0) continue;
            n += this.in.read(byArray, n, -this.oBuffSize - n);
        }
        this.oBuff = ByteBuffer.allocateDirect(this.oBuffSize);
        if (this.oBuff == null) {
            throw new IOException("Error allocating the output buffers of size " + this.oBuffSize);
        }
        for (long i = 0L; i < (long)n; i += (long)n2) {
            n2 = ZstdInputStream.nextSrcSizeToDecompress(this.ctx);
            int n3 = ZstdInputStream.decompressContinue(this.ctx, this.oBuff, this.oPos, this.oBuffSize - this.oPos, byArray, i, n2);
            if (Zstd.isError(n3)) {
                throw new IOException("Decode Error: " + Zstd.getErrorName(n3));
            }
            this.oEnd += n3;
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.legacy != null) {
            return this.legacy.read(byArray, n, n2);
        }
        if (n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("Requested lenght " + n2 + " exceeds the buffer size " + byArray.length + " from offset " + n);
        }
        while (this.oEnd == this.oPos) {
            int n4;
            n3 = 0;
            int n5 = ZstdInputStream.nextSrcSizeToDecompress(this.ctx);
            if (n5 == 0) {
                return -1;
            }
            if (this.oBuffSize - this.oPos < this.blockSize) {
                this.oPos = 0;
                this.oEnd = 0;
            }
            while (n3 < n5) {
                n4 = this.in.read(this.iBuff, n3, n5 - n3);
                if (n4 > 0) {
                    n3 += n4;
                    continue;
                }
                throw new IOException("Read error or truncated source");
            }
            n4 = ZstdInputStream.decompressContinue(this.ctx, this.oBuff, this.oPos, this.oBuffSize - this.oPos, this.iBuff, 0L, n3);
            if (Zstd.isError(n4)) {
                throw new IOException("Decode Error: " + Zstd.getErrorName(n4));
            }
            this.oEnd += n4;
        }
        n3 = Math.min(n2, this.oEnd - this.oPos);
        this.oBuff.position(this.oPos);
        this.oBuff.get(byArray, n, n3);
        this.oPos += n3;
        return n3;
    }

    @Override
    public int available() throws IOException {
        if (this.legacy != null) {
            return this.legacy.available();
        }
        return this.oEnd - this.oPos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.legacy != null) {
            return this.legacy.skip(l);
        }
        if (l <= (long)(this.oEnd - this.oPos)) {
            this.oPos = (int)((long)this.oPos + l);
            return l;
        }
        long l2 = this.oEnd - this.oPos;
        this.oPos = this.oEnd;
        return l2;
    }

    @Override
    public void close() throws IOException {
        if (this.legacy != null) {
            this.legacy.close();
        } else {
            ZstdInputStream.freeDCtx(this.ctx);
            this.in.close();
        }
    }

    static {
        Native.load();
    }
}

