/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.util.Native;
import java.io.IOException;
import java.io.InputStream;

public class ZstdContinuousInputStream
extends ZstdInputStream {
    private int toRead = 0;
    private int iPos = 0;

    public ZstdContinuousInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("Requested lenght " + n2 + " exceeds the buffer size " + byArray.length + " from offset " + n);
        }
        while (this.oEnd == this.oPos) {
            if (this.toRead - this.iPos == 0) {
                this.iPos = 0;
                this.toRead = ZstdContinuousInputStream.nextSrcSizeToDecompress(this.ctx);
            }
            if (this.toRead == 0) {
                return -1;
            }
            if (this.oBuffSize - this.oPos < this.blockSize) {
                this.oPos = 0;
                this.oEnd = 0;
            }
            while (this.iPos < this.toRead) {
                n3 = this.in.read(this.iBuff, this.iPos, this.toRead - this.iPos);
                if (n3 > 0) {
                    this.iPos += n3;
                    continue;
                }
                return 0;
            }
            n3 = ZstdContinuousInputStream.decompressContinue(this.ctx, this.oBuff, this.oPos, this.oBuffSize - this.oPos, this.iBuff, 0L, this.iPos);
            if (Zstd.isError(n3)) {
                throw new IOException("Decode Error: " + Zstd.getErrorName(n3));
            }
            this.oEnd += n3;
        }
        n3 = Math.min(n2, this.oEnd - this.oPos);
        this.oBuff.position(this.oPos);
        this.oBuff.get(byArray, n, n3);
        this.oPos += n3;
        return n3;
    }

    @Override
    public int available() throws IOException {
        return this.oEnd - this.oPos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long l) throws IOException {
        if (l <= (long)(this.oEnd - this.oPos)) {
            this.oPos = (int)((long)this.oPos + l);
            return l;
        }
        long l2 = this.oEnd - this.oPos;
        this.oPos = this.oEnd;
        return l2;
    }

    @Override
    public void close() throws IOException {
        ZstdContinuousInputStream.freeDCtx(this.ctx);
        this.in.close();
    }

    static {
        Native.load();
    }
}

