/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZstdDirectBufferCompressingStream
implements Closeable,
Flushable {
    private ByteBuffer target;
    private final long stream;
    private int consumed = 0;
    private int produced = 0;
    private boolean closed = false;

    protected ByteBuffer flushBuffer(ByteBuffer toFlush) throws IOException {
        return toFlush;
    }

    protected ZstdDirectBufferCompressingStream(ByteBuffer target, int level) throws IOException {
        this.target = target;
        if (!target.isDirect()) {
            throw new IllegalArgumentException("Target buffer should be a direct buffer");
        }
        this.stream = ZstdDirectBufferCompressingStream.createCStream();
        int size = this.initCStream(this.stream, level);
        if (Zstd.isError(size)) {
            throw new IOException("Compression error: cannot create header: " + Zstd.getErrorName(size));
        }
    }

    public static int recommendedOutputBufferSize() {
        return (int)ZstdDirectBufferCompressingStream.recommendedCOutSize();
    }

    private static native long recommendedCOutSize();

    private static native long createCStream();

    private static native int freeCStream(long var0);

    private native int initCStream(long var1, int var3);

    private native int compressDirectByteBuffer(long var1, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8);

    private native int flushStream(long var1, ByteBuffer var3, int var4, int var5);

    private native int endStream(long var1, ByteBuffer var3, int var4, int var5);

    public void compress(ByteBuffer source) throws IOException {
        if (!source.isDirect()) {
            throw new IllegalArgumentException("Source buffer should be a direct buffer");
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        while (source.hasRemaining()) {
            int result;
            if (!this.target.hasRemaining()) {
                this.target = this.flushBuffer(this.target);
                if (!this.target.isDirect()) {
                    throw new IllegalArgumentException("Target buffer should be a direct buffer");
                }
                if (!this.target.hasRemaining()) {
                    throw new IOException("The target buffer has no more space, even after flushing, and there are still bytes to compress");
                }
            }
            if (Zstd.isError(result = this.compressDirectByteBuffer(this.stream, this.target, this.target.position(), this.target.remaining(), source, source.position(), source.remaining()))) {
                throw new IOException("Compression error: " + Zstd.getErrorName(result));
            }
            this.target.position(this.target.position() + this.produced);
            source.position(source.position() + this.consumed);
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.closed) {
            int needed;
            do {
                if (Zstd.isError(needed = this.flushStream(this.stream, this.target, this.target.position(), this.target.remaining()))) {
                    throw new IOException("Compression error: " + Zstd.getErrorName(needed));
                }
                this.target.position(this.target.position() + this.produced);
                this.target = this.flushBuffer(this.target);
                if (!this.target.isDirect()) {
                    throw new IllegalArgumentException("Target buffer should be a direct buffer");
                }
                if (needed <= 0 || this.target.hasRemaining()) continue;
                throw new IOException("The target buffer has no more space, even after flushing, and there are still bytes to compress");
            } while (needed > 0);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                int needed;
                do {
                    if (Zstd.isError(needed = this.endStream(this.stream, this.target, this.target.position(), this.target.remaining()))) {
                        throw new IOException("Compression error: " + Zstd.getErrorName(needed));
                    }
                    this.target.position(this.target.position() + this.produced);
                    this.target = this.flushBuffer(this.target);
                    if (!this.target.isDirect()) {
                        throw new IllegalArgumentException("Target buffer should be a direct buffer");
                    }
                    if (needed <= 0 || this.target.hasRemaining()) continue;
                    throw new IOException("The target buffer has no more space, even after flushing, and there are still bytes to compress");
                } while (needed > 0);
            }
            finally {
                ZstdDirectBufferCompressingStream.freeCStream(this.stream);
                this.closed = true;
                this.target = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static {
        Native.load();
    }
}

