/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.util.Native;
import java.io.Closeable;
import java.io.IOException;

public class ZstdDictDecompress
implements Closeable {
    private long nativePtr = 0L;

    private native void init(byte[] var1, int var2, int var3);

    private native void free();

    public ZstdDictDecompress(byte[] dict) {
        this(dict, 0, dict.length);
    }

    public ZstdDictDecompress(byte[] dict, int offset, int length) {
        if (dict.length < 0) {
            throw new IllegalArgumentException("Dictionary buffer is to short");
        }
        this.init(dict, offset, length);
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("ZSTD_createDDict failed");
        }
    }

    @Override
    public void close() throws IOException {
        this.free();
        this.nativePtr = 0L;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static {
        Native.load();
    }
}

