/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZstdInputStream
extends FilterInputStream {
    private long stream;
    private long dstPos = 0L;
    private long srcPos = 0L;
    private long srcSize = 0L;
    private byte[] src = new byte[srcBuffSize];
    private static final int srcBuffSize;
    private boolean isContinuous = false;
    private boolean frameFinished = true;
    private boolean isClosed = false;

    private static native long recommendedDInSize();

    private static native long recommendedDOutSize();

    private static native long createDStream();

    private static native int freeDStream(long var0);

    private native int initDStream(long var1);

    private native int decompressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    public ZstdInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        if (this.src == null) {
            throw new IOException("Error allocating the input buffer of size " + srcBuffSize);
        }
        this.stream = ZstdInputStream.createDStream();
        int n = this.initDStream(this.stream);
        if (Zstd.isError(n)) {
            throw new IOException("Decompression error: " + Zstd.getErrorName(n));
        }
    }

    public ZstdInputStream setContinuous(boolean bl) {
        this.isContinuous = bl;
        return this;
    }

    public boolean getContinuous() {
        return this.isContinuous;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (n < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("Requested lenght " + n2 + " from offset " + n + " in buffer of size " + byArray.length);
        }
        int n3 = n + n2;
        this.dstPos = n;
        while (this.dstPos < (long)n3) {
            int n4;
            if (this.srcSize - this.srcPos == 0L) {
                this.srcSize = this.in.read(this.src, 0, srcBuffSize);
                this.srcPos = 0L;
                if (this.srcSize < 0L) {
                    this.srcSize = 0L;
                    if (this.frameFinished) {
                        return -1;
                    }
                    if (this.isContinuous) {
                        return (int)(this.dstPos - (long)n);
                    }
                    throw new IOException("Read error or truncated source");
                }
                this.frameFinished = false;
            }
            if (Zstd.isError(n4 = this.decompressStream(this.stream, byArray, n3, this.src, (int)this.srcSize))) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(n4));
            }
            if (n4 != 0) continue;
            this.frameFinished = true;
            n4 = this.initDStream(this.stream);
            if (Zstd.isError(n4)) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(n4));
            }
            return (int)(this.dstPos - (long)n);
        }
        return n2;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n > 0) {
            return byArray[0] & 0xFF;
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (this.srcSize - this.srcPos > 0L) {
            return (int)(this.srcSize - this.srcPos);
        }
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long l) throws IOException {
        int n;
        long l2;
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (l <= 0L) {
            return 0L;
        }
        int n2 = (int)Math.min(ZstdInputStream.recommendedDOutSize(), l2);
        byte[] byArray = new byte[n2];
        for (l2 = l; l2 > 0L && (n = this.read(byArray, 0, (int)Math.min((long)n2, l2))) >= 0; l2 -= (long)n) {
        }
        return l - l2;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        ZstdInputStream.freeDStream(this.stream);
        this.in.close();
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static {
        Native.load();
        srcBuffSize = (int)ZstdInputStream.recommendedDInSize();
    }
}

