/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.util.Native;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZstdDirectBufferDecompressingStream
implements Closeable {
    private ByteBuffer source;
    private final long stream;
    private boolean finishedFrame = false;
    private boolean closed = false;
    private boolean streamEnd = false;
    private boolean initialized = false;
    private byte[] dict = null;
    private ZstdDictDecompress fastDict = null;
    private int consumed;
    private int produced;

    protected ByteBuffer refill(ByteBuffer toRefill) {
        return toRefill;
    }

    private static native int recommendedDOutSize();

    private static native long createDStream();

    private static native int freeDStream(long var0);

    private native int initDStream(long var1);

    private native int initDStreamWithDict(long var1, byte[] var3, int var4);

    private native int initDStreamWithFastDict(long var1, ZstdDictDecompress var3);

    private native long decompressStream(long var1, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8);

    public ZstdDirectBufferDecompressingStream(ByteBuffer source) {
        if (!source.isDirect()) {
            throw new IllegalArgumentException("Source buffer should be a direct buffer");
        }
        this.source = source;
        this.stream = ZstdDirectBufferDecompressingStream.createDStream();
    }

    public boolean hasRemaining() {
        return !this.streamEnd && (this.source.hasRemaining() || !this.finishedFrame);
    }

    public static int recommendedTargetBufferSize() {
        return ZstdDirectBufferDecompressingStream.recommendedDOutSize();
    }

    public ZstdDirectBufferDecompressingStream setDict(byte[] dict) throws IOException {
        if (this.initialized) {
            throw new IOException("Change of parameter on initialized stream");
        }
        this.dict = dict;
        this.fastDict = null;
        return this;
    }

    public ZstdDirectBufferDecompressingStream setDict(ZstdDictDecompress dict) throws IOException {
        if (this.initialized) {
            throw new IOException("Change of parameter on initialized stream");
        }
        this.fastDict = dict;
        this.dict = null;
        return this;
    }

    private void initStream() throws IOException {
        int result = 0;
        result = this.fastDict != null ? this.initDStreamWithFastDict(this.stream, this.fastDict) : (this.dict != null ? this.initDStreamWithDict(this.stream, this.dict, this.dict.length) : this.initDStream(this.stream));
        if (Zstd.isError(result)) {
            throw new IOException("Decompression error: " + Zstd.getErrorName(result));
        }
        this.initialized = true;
    }

    public int read(ByteBuffer target) throws IOException {
        long remaining;
        if (!target.isDirect()) {
            throw new IllegalArgumentException("Target buffer should be a direct buffer");
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.streamEnd) {
            return 0;
        }
        if (!this.initialized) {
            this.initStream();
        }
        if (Zstd.isError(remaining = this.decompressStream(this.stream, target, target.position(), target.remaining(), this.source, this.source.position(), this.source.remaining()))) {
            throw new IOException(Zstd.getErrorName(remaining));
        }
        this.source.position(this.source.position() + this.consumed);
        target.position(target.position() + this.produced);
        if (!this.source.hasRemaining()) {
            this.source = this.refill(this.source);
            if (!this.source.isDirect()) {
                throw new IllegalArgumentException("Source buffer should be a direct buffer");
            }
        }
        boolean bl = this.finishedFrame = remaining == 0L;
        if (this.finishedFrame) {
            if (this.source.hasRemaining()) {
                this.initStream();
            } else {
                this.streamEnd = true;
            }
        }
        return this.produced;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (this.initialized) {
                    ZstdDirectBufferDecompressingStream.freeDStream(this.stream);
                }
            }
            finally {
                this.closed = true;
                this.initialized = false;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed && this.initialized) {
            ZstdDirectBufferDecompressingStream.freeDStream(this.stream);
        }
        this.source = null;
    }

    static {
        Native.load();
    }
}

