/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.util.Native;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZstdInputStream
extends FilterInputStream {
    private long stream;
    private long dstPos = 0L;
    private long srcPos = 0L;
    private long srcSize = 0L;
    private byte[] src = new byte[srcBuffSize];
    private static final int srcBuffSize;
    private boolean isContinuous = false;
    private boolean frameFinished = true;
    private boolean isClosed = false;
    private byte[] dict = null;
    private ZstdDictDecompress fastDict = null;

    private static native long recommendedDInSize();

    private static native long recommendedDOutSize();

    private static native long createDStream();

    private static native int freeDStream(long var0);

    private native int initDStream(long var1);

    private native int initDStreamWithDict(long var1, byte[] var3, int var4);

    private native int initDStreamWithFastDict(long var1, ZstdDictDecompress var3);

    private native int decompressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    public ZstdInputStream(InputStream inStream) throws IOException {
        super(inStream);
        if (this.src == null) {
            throw new IOException("Error allocating the input buffer of size " + srcBuffSize);
        }
        this.stream = ZstdInputStream.createDStream();
    }

    public ZstdInputStream setContinuous(boolean b) {
        this.isContinuous = b;
        return this;
    }

    public boolean getContinuous() {
        return this.isContinuous;
    }

    public ZstdInputStream setDict(byte[] dict) throws IOException {
        if (!this.frameFinished) {
            throw new IOException("Change of parameter on initialized stream");
        }
        this.dict = dict;
        this.fastDict = null;
        return this;
    }

    public ZstdInputStream setDict(ZstdDictDecompress dict) throws IOException {
        if (!this.frameFinished) {
            throw new IOException("Change of parameter on initialized stream");
        }
        this.fastDict = dict;
        this.dict = null;
        return this;
    }

    @Override
    public int read(byte[] dst, int offset, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (this.frameFinished) {
            int size = 0;
            size = this.fastDict != null ? this.initDStreamWithFastDict(this.stream, this.fastDict) : (this.dict != null ? this.initDStreamWithDict(this.stream, this.dict, this.dict.length) : this.initDStream(this.stream));
            if (Zstd.isError(size)) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(size));
            }
        }
        if (offset < 0 || len > dst.length - offset) {
            throw new IndexOutOfBoundsException("Requested lenght " + len + " from offset " + offset + " in buffer of size " + dst.length);
        }
        int dstSize = offset + len;
        this.dstPos = offset;
        while (this.dstPos < (long)dstSize) {
            int size;
            if (this.srcSize - this.srcPos == 0L) {
                this.srcSize = this.in.read(this.src, 0, srcBuffSize);
                this.srcPos = 0L;
                if (this.srcSize < 0L) {
                    this.srcSize = 0L;
                    if (this.frameFinished) {
                        return -1;
                    }
                    if (this.isContinuous) {
                        return (int)(this.dstPos - (long)offset);
                    }
                    throw new IOException("Read error or truncated source");
                }
                this.frameFinished = false;
            }
            if (Zstd.isError(size = this.decompressStream(this.stream, dst, dstSize, this.src, (int)this.srcSize))) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(size));
            }
            if (size != 0) continue;
            this.frameFinished = true;
            return (int)(this.dstPos - (long)offset);
        }
        return len;
    }

    @Override
    public int read() throws IOException {
        byte[] oneByte = new byte[1];
        int result = this.read(oneByte, 0, 1);
        if (result > 0) {
            return oneByte[0] & 0xFF;
        }
        return result;
    }

    @Override
    public int available() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (this.srcSize - this.srcPos > 0L) {
            return (int)(this.srcSize - this.srcPos);
        }
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long numBytes) throws IOException {
        int read;
        long toSkip;
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (numBytes <= 0L) {
            return 0L;
        }
        int bufferLen = (int)Math.min(ZstdInputStream.recommendedDOutSize(), toSkip);
        byte[] data = new byte[bufferLen];
        for (toSkip = numBytes; toSkip > 0L && (read = this.read(data, 0, (int)Math.min((long)bufferLen, toSkip))) >= 0; toSkip -= (long)read) {
        }
        return numBytes - toSkip;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        ZstdInputStream.freeDStream(this.stream);
        this.in.close();
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static {
        Native.load();
        srcBuffSize = (int)ZstdInputStream.recommendedDInSize();
    }
}

