/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ZstdDictTrainer {
    private final int allocatedSize;
    private final ByteBuffer trainingSamples;
    private final List<Integer> sampleSizes;
    private final int dictSize;
    private long filledSize;

    public ZstdDictTrainer(int sampleSize, int dictSize) {
        this.trainingSamples = ByteBuffer.allocateDirect(sampleSize);
        this.sampleSizes = new ArrayList<Integer>();
        this.allocatedSize = sampleSize;
        this.dictSize = dictSize;
    }

    public boolean addSample(byte[] sample) {
        if (this.filledSize + (long)sample.length > (long)this.allocatedSize) {
            return false;
        }
        this.trainingSamples.put(sample);
        this.sampleSizes.add(sample.length);
        this.filledSize += (long)sample.length;
        return true;
    }

    public ByteBuffer trainSamplesDirect() {
        return this.trainSamplesDirect(false);
    }

    public ByteBuffer trainSamplesDirect(boolean legacy) {
        ByteBuffer dictBuffer = ByteBuffer.allocateDirect(this.dictSize);
        long l = Zstd.trainFromBufferDirect(this.trainingSamples, this.copyToIntArray(this.sampleSizes), dictBuffer, legacy);
        if (Zstd.isError(l)) {
            dictBuffer.limit(0);
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        dictBuffer.limit(Long.valueOf(l).intValue());
        return dictBuffer;
    }

    public byte[] trainSamples() {
        return this.trainSamples(false);
    }

    public byte[] trainSamples(boolean legacy) {
        ByteBuffer byteBuffer = this.trainSamplesDirect(legacy);
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        return bytes;
    }

    private int[] copyToIntArray(List<Integer> list) {
        int[] ints = new int[list.size()];
        int idx = 0;
        for (Integer i : list) {
            ints[idx] = i;
            ++idx;
        }
        return ints;
    }
}

