/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.util.Native;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ZstdOutputStream
extends FilterOutputStream {
    private final long stream;
    private long srcPos = 0L;
    private long dstPos = 0L;
    private final byte[] dst;
    private boolean isClosed = false;
    private static final int dstSize;
    private final boolean closeFrameOnFlush;
    private boolean useChecksum;
    private boolean frameClosed = true;
    private final int level;
    private byte[] dict = null;
    private ZstdDictCompress fastDict = null;

    private static native long recommendedCOutSize();

    private static native long createCStream();

    private static native int freeCStream(long var0);

    private native int initCStream(long var1, int var3, int var4);

    private native int initCStreamWithDict(long var1, byte[] var3, int var4, int var5, int var6);

    private native int initCStreamWithFastDict(long var1, ZstdDictCompress var3, int var4);

    private native int compressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    private native int flushStream(long var1, byte[] var3, int var4);

    private native int endStream(long var1, byte[] var3, int var4);

    public ZstdOutputStream(OutputStream outStream, int level, boolean closeFrameOnFlush, boolean useChecksum) throws IOException {
        super(outStream);
        this.closeFrameOnFlush = closeFrameOnFlush;
        this.level = level;
        this.useChecksum = useChecksum;
        this.stream = ZstdOutputStream.createCStream();
        this.dst = new byte[dstSize];
    }

    public ZstdOutputStream(OutputStream outStream, int level, boolean closeFrameOnFlush) throws IOException {
        this(outStream, level, closeFrameOnFlush, false);
    }

    public ZstdOutputStream(OutputStream outStream, int level) throws IOException {
        this(outStream, level, false);
    }

    public ZstdOutputStream(OutputStream outStream) throws IOException {
        this(outStream, 3, false);
    }

    public synchronized ZstdOutputStream setChecksum(boolean useChecksum) throws IOException {
        if (!this.frameClosed) {
            throw new IOException("Change of parameter on initialized stream");
        }
        this.useChecksum = useChecksum;
        return this;
    }

    public synchronized ZstdOutputStream setDict(byte[] dict) throws IOException {
        if (!this.frameClosed) {
            throw new IOException("Change of parameter on initialized stream");
        }
        this.fastDict = null;
        this.dict = dict;
        return this;
    }

    public synchronized ZstdOutputStream setDict(ZstdDictCompress dict) throws IOException {
        if (!this.frameClosed) {
            throw new IOException("Change of parameter on initialized stream");
        }
        this.dict = null;
        this.fastDict = dict;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(byte[] src, int offset, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (this.frameClosed) {
            int size = 0;
            ZstdDictCompress fastDict = this.fastDict;
            if (fastDict != null) {
                fastDict.acquireSharedLock();
                try {
                    size = this.initCStreamWithFastDict(this.stream, fastDict, this.useChecksum ? 1 : 0);
                }
                finally {
                    fastDict.releaseSharedLock();
                }
            } else {
                size = this.dict != null ? this.initCStreamWithDict(this.stream, this.dict, this.dict.length, this.level, this.useChecksum ? 1 : 0) : this.initCStream(this.stream, this.level, this.useChecksum ? 1 : 0);
            }
            if (Zstd.isError(size)) {
                throw new IOException("Compression error: cannot create header: " + Zstd.getErrorName(size));
            }
            this.frameClosed = false;
        }
        int srcSize = offset + len;
        this.srcPos = offset;
        while (this.srcPos < (long)srcSize) {
            int size = this.compressStream(this.stream, this.dst, dstSize, src, srcSize);
            if (Zstd.isError(size)) {
                throw new IOException("Compression error: " + Zstd.getErrorName(size));
            }
            if (this.dstPos <= 0L) continue;
            this.out.write(this.dst, 0, (int)this.dstPos);
        }
    }

    @Override
    public void write(int i) throws IOException {
        byte[] oneByte = new byte[]{(byte)i};
        this.write(oneByte, 0, 1);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (!this.frameClosed) {
            if (this.closeFrameOnFlush) {
                int size = this.endStream(this.stream, this.dst, dstSize);
                if (Zstd.isError(size)) {
                    throw new IOException("Compression error: " + Zstd.getErrorName(size));
                }
                this.frameClosed = true;
            } else {
                int size = this.flushStream(this.stream, this.dst, dstSize);
                if (Zstd.isError(size)) {
                    throw new IOException("Compression error: " + Zstd.getErrorName(size));
                }
            }
            this.out.write(this.dst, 0, (int)this.dstPos);
            this.out.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (!this.frameClosed) {
            int size = this.endStream(this.stream, this.dst, dstSize);
            if (Zstd.isError(size)) {
                throw new IOException("Compression error: " + Zstd.getErrorName(size));
            }
            this.out.write(this.dst, 0, (int)this.dstPos);
        }
        ZstdOutputStream.freeCStream(this.stream);
        this.out.close();
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static {
        Native.load();
        dstSize = (int)ZstdOutputStream.recommendedCOutSize();
    }
}

