/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.util.Native;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZstdInputStream
extends FilterInputStream {
    private final long stream;
    private long dstPos = 0L;
    private long srcPos = 0L;
    private long srcSize = 0L;
    private byte[] src = new byte[srcBuffSize];
    private static final int srcBuffSize;
    private boolean isContinuous = false;
    private boolean frameFinished = true;
    private boolean isClosed = false;

    private static native long recommendedDInSize();

    private static native long recommendedDOutSize();

    private static native long createDStream();

    private static native int freeDStream(long var0);

    private native int initDStream(long var1);

    private native int decompressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdInputStream(InputStream inStream) throws IOException {
        super(inStream);
        ZstdInputStream zstdInputStream = this;
        synchronized (zstdInputStream) {
            this.stream = ZstdInputStream.createDStream();
            this.initDStream(this.stream);
        }
    }

    public synchronized ZstdInputStream setContinuous(boolean b) {
        this.isContinuous = b;
        return this;
    }

    public synchronized boolean getContinuous() {
        return this.isContinuous;
    }

    public synchronized ZstdInputStream setDict(byte[] dict) throws IOException {
        int size = Zstd.loadDictDecompress(this.stream, dict, dict.length);
        if (Zstd.isError(size)) {
            throw new IOException("Decompression error: " + Zstd.getErrorName(size));
        }
        return this;
    }

    public synchronized ZstdInputStream setDict(ZstdDictDecompress dict) throws IOException {
        dict.acquireSharedLock();
        try {
            int size = Zstd.loadFastDictDecompress(this.stream, dict);
            if (Zstd.isError(size)) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(size));
            }
        }
        finally {
            dict.releaseSharedLock();
        }
        return this;
    }

    @Override
    public synchronized int read(byte[] dst, int offset, int len) throws IOException {
        if (offset < 0 || len > dst.length - offset) {
            throw new IndexOutOfBoundsException("Requested lenght " + len + " from offset " + offset + " in buffer of size " + dst.length);
        }
        if (len == 0) {
            return 0;
        }
        int result = 0;
        while (result == 0) {
            result = this.readInternal(dst, offset, len);
        }
        return result;
    }

    int readInternal(byte[] dst, int offset, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (offset < 0 || len > dst.length - offset) {
            throw new IndexOutOfBoundsException("Requested lenght " + len + " from offset " + offset + " in buffer of size " + dst.length);
        }
        int dstSize = offset + len;
        this.dstPos = offset;
        while (this.dstPos < (long)dstSize) {
            int size;
            if (this.srcSize - this.srcPos == 0L) {
                this.srcSize = this.in.read(this.src, 0, srcBuffSize);
                this.srcPos = 0L;
                if (this.srcSize < 0L) {
                    this.srcSize = 0L;
                    if (this.frameFinished) {
                        return -1;
                    }
                    if (this.isContinuous) {
                        return (int)(this.dstPos - (long)offset);
                    }
                    throw new IOException("Read error or truncated source");
                }
                this.frameFinished = false;
            }
            if (Zstd.isError(size = this.decompressStream(this.stream, dst, dstSize, this.src, (int)this.srcSize))) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(size));
            }
            if (size != 0) continue;
            this.frameFinished = true;
            return (int)(this.dstPos - (long)offset);
        }
        return len;
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] oneByte = new byte[1];
        int result = 0;
        while (result == 0) {
            result = this.readInternal(oneByte, 0, 1);
        }
        if (result == 1) {
            return oneByte[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (this.srcSize - this.srcPos > 0L) {
            return (int)(this.srcSize - this.srcPos);
        }
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized long skip(long numBytes) throws IOException {
        int read;
        long toSkip;
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (numBytes <= 0L) {
            return 0L;
        }
        int bufferLen = (int)Math.min(ZstdInputStream.recommendedDOutSize(), toSkip);
        byte[] data = new byte[bufferLen];
        for (toSkip = numBytes; toSkip > 0L && (read = this.read(data, 0, (int)Math.min((long)bufferLen, toSkip))) >= 0; toSkip -= (long)read) {
        }
        return numBytes - toSkip;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        ZstdInputStream.freeDStream(this.stream);
        this.in.close();
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static {
        Native.load();
        srcBuffSize = (int)ZstdInputStream.recommendedDInSize();
    }
}

