/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Zstd {
    public static native long compress(byte[] var0, byte[] var1, int var2, boolean var3);

    public static long compress(byte[] dst, byte[] src, int level) {
        return Zstd.compress(dst, src, level, false);
    }

    public static native long compressByteArray(byte[] var0, int var1, int var2, byte[] var3, int var4, int var5, int var6, boolean var7);

    public static long compressByteArray(byte[] dst, int dstOffset, int dstSize, byte[] src, int srcOffset, int srcSize, int level) {
        return Zstd.compressByteArray(dst, dstOffset, dstSize, src, srcOffset, srcSize, level, false);
    }

    public static long compressDirectByteBuffer(ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize, int level, boolean checksumFlag) {
        if (!src.isDirect()) {
            throw new IllegalArgumentException("src must be a direct buffer");
        }
        if (!dst.isDirect()) {
            throw new IllegalArgumentException("dst must be a direct buffer");
        }
        long result = Zstd.compressDirectByteBuffer0(dst, dstOffset, dstSize, src, srcOffset, srcSize, level, checksumFlag);
        if (Zstd.isError(result)) {
            throw new ZstdException(result);
        }
        return (int)result;
    }

    private static native long compressDirectByteBuffer0(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5, int var6, boolean var7);

    public static long compressDirectByteBuffer(ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize, int level) {
        return Zstd.compressDirectByteBuffer(dst, dstOffset, dstSize, src, srcOffset, srcSize, level, false);
    }

    public static native long compressUnsafe(long var0, long var2, long var4, long var6, int var8, boolean var9);

    public static long compressUnsafe(long dst, long dstSize, long src, long srcSize, int level) {
        return Zstd.compressUnsafe(dst, dstSize, src, srcSize, level, false);
    }

    public static native long compressUsingDict(byte[] var0, int var1, byte[] var2, int var3, int var4, byte[] var5, int var6);

    public static long compressDirectByteBufferUsingDict(ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize, byte[] dict, int level) {
        if (!src.isDirect()) {
            throw new IllegalArgumentException("src must be a direct buffer");
        }
        if (!dst.isDirect()) {
            throw new IllegalArgumentException("dst must be a direct buffer");
        }
        long result = Zstd.compressDirectByteBufferUsingDict0(dst, dstOffset, dstSize, src, srcOffset, srcSize, dict, level);
        if (Zstd.isError(result)) {
            throw new ZstdException(result);
        }
        return (int)result;
    }

    private static native long compressDirectByteBufferUsingDict0(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5, byte[] var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressFastDict(byte[] dst, int dstOffset, byte[] src, int srcOffset, int length, ZstdDictCompress dict) {
        dict.acquireSharedLock();
        try {
            long l = Zstd.compressFastDict0(dst, dstOffset, src, srcOffset, length, dict);
            return l;
        }
        finally {
            dict.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compress(byte[] dst, byte[] src, ZstdDictCompress dict) {
        dict.acquireSharedLock();
        try {
            long l = Zstd.compressFastDict0(dst, 0, src, 0, src.length, dict);
            return l;
        }
        finally {
            dict.releaseSharedLock();
        }
    }

    private static native long compressFastDict0(byte[] var0, int var1, byte[] var2, int var3, int var4, ZstdDictCompress var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressDirectByteBufferFastDict(ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize, ZstdDictCompress dict) {
        if (!src.isDirect()) {
            throw new IllegalArgumentException("src must be a direct buffer");
        }
        if (!dst.isDirect()) {
            throw new IllegalArgumentException("dst must be a direct buffer");
        }
        dict.acquireSharedLock();
        try {
            long l = Zstd.compressDirectByteBufferFastDict0(dst, dstOffset, dstSize, src, srcOffset, srcSize, dict);
            return l;
        }
        finally {
            dict.releaseSharedLock();
        }
    }

    public static native long compressDirectByteBufferFastDict0(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5, ZstdDictCompress var6);

    public static native long decompress(byte[] var0, byte[] var1);

    public static native long decompressByteArray(byte[] var0, int var1, int var2, byte[] var3, int var4, int var5);

    public static native long decompressDirectByteBuffer(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5);

    public static native long decompressUnsafe(long var0, long var2, long var4, long var6);

    public static native long decompressUsingDict(byte[] var0, int var1, byte[] var2, int var3, int var4, byte[] var5);

    public static long decompressDirectByteBufferUsingDict(ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize, byte[] dict) {
        if (!src.isDirect()) {
            throw new IllegalArgumentException("src must be a direct buffer");
        }
        if (!dst.isDirect()) {
            throw new IllegalArgumentException("dst must be a direct buffer");
        }
        long result = Zstd.decompressDirectByteBufferUsingDict0(dst, dstOffset, dstSize, src, srcOffset, srcSize, dict);
        if (Zstd.isError(result)) {
            throw new ZstdException(result);
        }
        return (int)result;
    }

    private static native long decompressDirectByteBufferUsingDict0(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5, byte[] var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressFastDict(byte[] dst, int dstOffset, byte[] src, int srcOffset, int length, ZstdDictDecompress dict) {
        dict.acquireSharedLock();
        try {
            long l = Zstd.decompressFastDict0(dst, dstOffset, src, srcOffset, length, dict);
            return l;
        }
        finally {
            dict.releaseSharedLock();
        }
    }

    private static native long decompressFastDict0(byte[] var0, int var1, byte[] var2, int var3, int var4, ZstdDictDecompress var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressDirectByteBufferFastDict(ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize, ZstdDictDecompress dict) {
        if (!src.isDirect()) {
            throw new IllegalArgumentException("src must be a direct buffer");
        }
        if (!dst.isDirect()) {
            throw new IllegalArgumentException("dst must be a direct buffer");
        }
        dict.acquireSharedLock();
        try {
            long l = Zstd.decompressDirectByteBufferFastDict0(dst, dstOffset, dstSize, src, srcOffset, srcSize, dict);
            return l;
        }
        finally {
            dict.releaseSharedLock();
        }
    }

    private static native long decompressDirectByteBufferFastDict0(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5, ZstdDictDecompress var6);

    public static native int loadDictDecompress(long var0, byte[] var2, int var3);

    public static native int loadFastDictDecompress(long var0, ZstdDictDecompress var2);

    public static native int loadDictCompress(long var0, byte[] var2, int var3);

    public static native int loadFastDictCompress(long var0, ZstdDictCompress var2);

    public static native int setCompressionChecksums(long var0, boolean var2);

    public static native int setCompressionLevel(long var0, int var2);

    public static native int setCompressionWorkers(long var0, int var2);

    public static native long decompressedSize(byte[] var0);

    public static native long decompressedDirectByteBufferSize(ByteBuffer var0, int var1, int var2);

    public static native long compressBound(long var0);

    public static native boolean isError(long var0);

    public static native String getErrorName(long var0);

    public static native long getErrorCode(long var0);

    public static native long errNoError();

    public static native long errGeneric();

    public static native long errPrefixUnknown();

    public static native long errVersionUnsupported();

    public static native long errFrameParameterUnsupported();

    public static native long errFrameParameterWindowTooLarge();

    public static native long errCorruptionDetected();

    public static native long errChecksumWrong();

    public static native long errDictionaryCorrupted();

    public static native long errDictionaryWrong();

    public static native long errDictionaryCreationFailed();

    public static native long errParameterUnsupported();

    public static native long errParameterOutOfBound();

    public static native long errTableLogTooLarge();

    public static native long errMaxSymbolValueTooLarge();

    public static native long errMaxSymbolValueTooSmall();

    public static native long errStageWrong();

    public static native long errInitMissing();

    public static native long errMemoryAllocation();

    public static native long errWorkSpaceTooSmall();

    public static native long errDstSizeTooSmall();

    public static native long errSrcSizeWrong();

    public static native long errDstBufferNull();

    public static native long trainFromBuffer(byte[][] var0, byte[] var1, boolean var2);

    public static native long trainFromBufferDirect(ByteBuffer var0, int[] var1, ByteBuffer var2, boolean var3);

    public static native long getDictIdFromFrame(byte[] var0);

    public static native long getDictIdFromFrameBuffer(ByteBuffer var0);

    public static native long getDictIdFromDict(byte[] var0);

    public static long trainFromBuffer(byte[][] samples, byte[] dictBuffer) {
        return Zstd.trainFromBuffer(samples, dictBuffer, false);
    }

    public static long trainFromBufferDirect(ByteBuffer samples, int[] sampleSizes, ByteBuffer dictBuffer) {
        return Zstd.trainFromBufferDirect(samples, sampleSizes, dictBuffer, false);
    }

    public static native int magicNumber();

    public static native int windowLogMin();

    public static native int windowLogMax();

    public static native int chainLogMin();

    public static native int chainLogMax();

    public static native int hashLogMin();

    public static native int hashLogMax();

    public static native int searchLogMin();

    public static native int searchLogMax();

    public static native int searchLengthMin();

    public static native int searchLengthMax();

    public static native int frameHeaderSizeMin();

    public static native int frameHeaderSizeMax();

    public static native int blockSizeMax();

    public static native int minCompressionLevel();

    public static native int maxCompressionLevel();

    public static byte[] compress(byte[] src) throws ZstdException {
        return Zstd.compress(src, 3);
    }

    public static byte[] compress(byte[] src, int level) throws ZstdException {
        long maxDstSize = Zstd.compressBound(src.length);
        if (maxDstSize > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        byte[] dst = new byte[(int)maxDstSize];
        long size = Zstd.compress(dst, src, level);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        return Arrays.copyOfRange(dst, 0, (int)size);
    }

    public static int compress(ByteBuffer dstBuf, ByteBuffer srcBuf) throws ZstdException {
        return Zstd.compress(dstBuf, srcBuf, 3);
    }

    public static int compress(ByteBuffer dstBuf, ByteBuffer srcBuf, int level, boolean checksumFlag) throws ZstdException {
        if (!srcBuf.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        if (!dstBuf.isDirect()) {
            throw new IllegalArgumentException("dstBuf must be a direct buffer");
        }
        long size = Zstd.compressDirectByteBuffer(dstBuf, dstBuf.position(), dstBuf.limit() - dstBuf.position(), srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position(), level, checksumFlag);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        srcBuf.position(srcBuf.limit());
        dstBuf.position(dstBuf.position() + (int)size);
        return (int)size;
    }

    public static int compress(ByteBuffer dstBuf, ByteBuffer srcBuf, int level) throws ZstdException {
        return Zstd.compress(dstBuf, srcBuf, level, false);
    }

    public static ByteBuffer compress(ByteBuffer srcBuf, int level) throws ZstdException {
        if (!srcBuf.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        long maxDstSize = Zstd.compressBound(srcBuf.limit() - srcBuf.position());
        if (maxDstSize > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        ByteBuffer dstBuf = ByteBuffer.allocateDirect((int)maxDstSize);
        long size = Zstd.compressDirectByteBuffer(dstBuf, 0, (int)maxDstSize, srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position(), level);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        srcBuf.position(srcBuf.limit());
        dstBuf.limit((int)size);
        return dstBuf;
    }

    public static byte[] compress(byte[] src, ZstdDictCompress dict) throws ZstdException {
        long maxDstSize = Zstd.compressBound(src.length);
        if (maxDstSize > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        byte[] dst = new byte[(int)maxDstSize];
        long size = Zstd.compressFastDict(dst, 0, src, 0, src.length, dict);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        return Arrays.copyOfRange(dst, 0, (int)size);
    }

    @Deprecated
    public static long compressUsingDict(byte[] dst, byte[] src, byte[] dict, int level) {
        return Zstd.compressUsingDict(dst, 0, src, 0, src.length, dict, level);
    }

    public static byte[] compressUsingDict(byte[] src, byte[] dict, int level) throws ZstdException {
        long maxDstSize = Zstd.compressBound(src.length);
        if (maxDstSize > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        byte[] dst = new byte[(int)maxDstSize];
        long size = Zstd.compressUsingDict(dst, 0, src, 0, src.length, dict, level);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        return Arrays.copyOfRange(dst, 0, (int)size);
    }

    public static long compress(byte[] dst, byte[] src, byte[] dict, int level) {
        return Zstd.compressUsingDict(dst, 0, src, 0, src.length, dict, level);
    }

    public static int compress(ByteBuffer dstBuff, ByteBuffer srcBuff, byte[] dict, int level) throws ZstdException {
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        if (!dstBuff.isDirect()) {
            throw new IllegalArgumentException("dstBuf must be a direct buffer");
        }
        long size = Zstd.compressDirectByteBufferUsingDict(dstBuff, dstBuff.position(), dstBuff.limit() - dstBuff.position(), srcBuff, srcBuff.position(), srcBuff.limit() - srcBuff.position(), dict, level);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        srcBuff.position(srcBuff.limit());
        dstBuff.position(dstBuff.position() + (int)size);
        return (int)size;
    }

    public static ByteBuffer compress(ByteBuffer srcBuff, byte[] dict, int level) throws ZstdException {
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        long maxDstSize = Zstd.compressBound(srcBuff.limit() - srcBuff.position());
        if (maxDstSize > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        ByteBuffer dstBuff = ByteBuffer.allocateDirect((int)maxDstSize);
        long size = Zstd.compressDirectByteBufferUsingDict(dstBuff, 0, (int)maxDstSize, srcBuff, srcBuff.position(), srcBuff.limit() - srcBuff.position(), dict, level);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        srcBuff.position(srcBuff.limit());
        dstBuff.limit((int)size);
        return dstBuff;
    }

    public static int compress(ByteBuffer dstBuff, ByteBuffer srcBuff, ZstdDictCompress dict) throws ZstdException {
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        if (!dstBuff.isDirect()) {
            throw new IllegalArgumentException("dstBuf must be a direct buffer");
        }
        long size = Zstd.compressDirectByteBufferFastDict(dstBuff, dstBuff.position(), dstBuff.limit() - dstBuff.position(), srcBuff, srcBuff.position(), srcBuff.limit() - srcBuff.position(), dict);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        srcBuff.position(srcBuff.limit());
        dstBuff.position(dstBuff.position() + (int)size);
        return (int)size;
    }

    public static ByteBuffer compress(ByteBuffer srcBuff, ZstdDictCompress dict) throws ZstdException {
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        long maxDstSize = Zstd.compressBound(srcBuff.limit() - srcBuff.position());
        if (maxDstSize > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        ByteBuffer dstBuff = ByteBuffer.allocateDirect((int)maxDstSize);
        long size = Zstd.compressDirectByteBufferFastDict(dstBuff, 0, (int)maxDstSize, srcBuff, srcBuff.position(), srcBuff.limit() - srcBuff.position(), dict);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        srcBuff.position(srcBuff.limit());
        dstBuff.limit((int)size);
        return dstBuff;
    }

    public static byte[] decompress(byte[] src, int originalSize) throws ZstdException {
        byte[] dst = new byte[originalSize];
        long size = Zstd.decompress(dst, src);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        if (size != (long)originalSize) {
            return Arrays.copyOfRange(dst, 0, (int)size);
        }
        return dst;
    }

    public static int decompress(ByteBuffer dstBuf, ByteBuffer srcBuf) throws ZstdException {
        if (!srcBuf.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        if (!dstBuf.isDirect()) {
            throw new IllegalArgumentException("dstBuf must be a direct buffer");
        }
        long size = Zstd.decompressDirectByteBuffer(dstBuf, dstBuf.position(), dstBuf.limit() - dstBuf.position(), srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position());
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        srcBuf.position(srcBuf.limit());
        dstBuf.position(dstBuf.position() + (int)size);
        return (int)size;
    }

    public static ByteBuffer decompress(ByteBuffer srcBuf, int originalSize) throws ZstdException {
        if (!srcBuf.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        ByteBuffer dstBuf = ByteBuffer.allocateDirect(originalSize);
        long size = Zstd.decompressDirectByteBuffer(dstBuf, 0, originalSize, srcBuf, srcBuf.position(), srcBuf.limit());
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        srcBuf.position(srcBuf.limit());
        return dstBuf;
    }

    public static byte[] decompress(byte[] src, ZstdDictDecompress dict, int originalSize) throws ZstdException {
        byte[] dst = new byte[originalSize];
        long size = Zstd.decompressFastDict(dst, 0, src, 0, src.length, dict);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        if (size != (long)originalSize) {
            return Arrays.copyOfRange(dst, 0, (int)size);
        }
        return dst;
    }

    @Deprecated
    public static long decompressUsingDict(byte[] dst, byte[] src, byte[] dict) {
        return Zstd.decompressUsingDict(dst, 0, src, 0, src.length, dict);
    }

    public static long decompress(byte[] dst, byte[] src, byte[] dict) {
        return Zstd.decompressUsingDict(dst, 0, src, 0, src.length, dict);
    }

    public static byte[] decompress(byte[] src, byte[] dict, int originalSize) throws ZstdException {
        byte[] dst = new byte[originalSize];
        long size = Zstd.decompressUsingDict(dst, 0, src, 0, src.length, dict);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        if (size != (long)originalSize) {
            return Arrays.copyOfRange(dst, 0, (int)size);
        }
        return dst;
    }

    public static long decompressedSize(ByteBuffer srcBuf) {
        return Zstd.decompressedDirectByteBufferSize(srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position());
    }

    public static int decompress(ByteBuffer dstBuff, ByteBuffer srcBuff, byte[] dict) throws ZstdException {
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!dstBuff.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        long size = Zstd.decompressDirectByteBufferUsingDict(dstBuff, dstBuff.position(), dstBuff.limit() - dstBuff.position(), srcBuff, srcBuff.position(), srcBuff.limit() - srcBuff.position(), dict);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        srcBuff.position(srcBuff.limit());
        dstBuff.position(dstBuff.position() + (int)size);
        return (int)size;
    }

    public static ByteBuffer decompress(ByteBuffer srcBuff, byte[] dict, int originalSize) throws ZstdException {
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        ByteBuffer dstBuff = ByteBuffer.allocateDirect(originalSize);
        long size = Zstd.decompressDirectByteBufferUsingDict(dstBuff, 0, originalSize, srcBuff, srcBuff.position(), srcBuff.limit(), dict);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        srcBuff.position(srcBuff.limit());
        return dstBuff;
    }

    public static int decompress(ByteBuffer dstBuff, ByteBuffer srcBuff, ZstdDictDecompress dict) throws ZstdException {
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!dstBuff.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        long size = Zstd.decompressDirectByteBufferFastDict(dstBuff, dstBuff.position(), dstBuff.limit() - dstBuff.position(), srcBuff, srcBuff.position(), srcBuff.limit() - srcBuff.position(), dict);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        srcBuff.position(srcBuff.limit());
        dstBuff.position(dstBuff.position() + (int)size);
        return (int)size;
    }

    public static ByteBuffer decompress(ByteBuffer srcBuff, ZstdDictDecompress dict, int originalSize) throws ZstdException {
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        ByteBuffer dstBuff = ByteBuffer.allocateDirect(originalSize);
        long size = Zstd.decompressDirectByteBufferFastDict(dstBuff, 0, originalSize, srcBuff, srcBuff.position(), srcBuff.limit(), dict);
        if (Zstd.isError(size)) {
            throw new ZstdException(size);
        }
        srcBuff.position(srcBuff.limit());
        return dstBuff;
    }

    static {
        Native.load();
    }
}

