/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.AutoCloseBase;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;

public class ZstdCompressCtx
extends AutoCloseBase {
    private long nativePtr = 0L;
    private ZstdDictCompress compression_dict = null;

    private native void init();

    private native void free();

    public ZstdCompressCtx() {
        this.init();
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createCompressCtx failed");
        }
        this.storeFence();
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            this.free();
            this.nativePtr = 0L;
        }
    }

    public void setLevel(int level) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setLevel0(level);
        this.releaseSharedLock();
    }

    private native void setLevel0(int var1);

    public void setChecksum(boolean checksumFlag) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setChecksum0(checksumFlag);
        this.releaseSharedLock();
    }

    private native void setChecksum0(boolean var1);

    public void setContentSize(boolean contentSizeFlag) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setContentSize0(contentSizeFlag);
        this.releaseSharedLock();
    }

    private native void setContentSize0(boolean var1);

    public void setDictID(boolean dictIDFlag) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setDictID0(dictIDFlag);
        this.releaseSharedLock();
    }

    private native void setDictID0(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDict(ZstdDictCompress dict) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        dict.acquireSharedLock();
        try {
            long result = this.loadCDictFast0(dict);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            this.compression_dict = dict;
        }
        finally {
            dict.releaseSharedLock();
            this.releaseSharedLock();
        }
    }

    private native long loadCDictFast0(ZstdDictCompress var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDict(byte[] dict) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        try {
            long result = this.loadCDict0(dict);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            this.compression_dict = null;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long loadCDict0(byte[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long compressDirectByteBuffer(ByteBuffer dstBuff, int dstOffset, int dstSize, ByteBuffer srcBuff, int srcOffset, int srcSize) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!dstBuff.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        this.acquireSharedLock();
        try {
            long result = this.compressDirectByteBuffer0(dstBuff, dstOffset, dstSize, srcBuff, srcOffset, srcSize);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            long l = result;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long compressDirectByteBuffer0(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6);

    static {
        Native.load();
    }
}

