/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.AutoCloseBase;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;

public class ZstdDecompressCtx
extends AutoCloseBase {
    private long nativePtr = 0L;
    private ZstdDictDecompress decompression_dict = null;

    private native void init();

    private native void free();

    public ZstdDecompressCtx() {
        this.init();
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createDeCompressCtx failed");
        }
        this.storeFence();
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            this.free();
            this.nativePtr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDict(ZstdDictDecompress dict) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Decompression context is closed");
        }
        this.acquireSharedLock();
        dict.acquireSharedLock();
        try {
            long result = this.loadDDictFast0(dict);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            this.decompression_dict = dict;
        }
        finally {
            dict.releaseSharedLock();
            this.releaseSharedLock();
        }
    }

    private native long loadDDictFast0(ZstdDictDecompress var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDict(byte[] dict) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        try {
            long result = this.loadDDict0(dict);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            this.decompression_dict = null;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long loadDDict0(byte[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decompressDirectByteBuffer(ByteBuffer dstBuff, int dstOffset, int dstSize, ByteBuffer srcBuff, int srcOffset, int srcSize) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Decompression context is closed");
        }
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!dstBuff.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        this.acquireSharedLock();
        try {
            long result = this.decompressDirectByteBuffer0(dstBuff, dstOffset, dstSize, srcBuff, srcOffset, srcSize);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            int n = (int)result;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long decompressDirectByteBuffer0(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6);

    static {
        Native.load();
    }
}

