/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public enum Native {

    private static final String libnameShort = "zstd-jni";
    private static final String libname = "libzstd-jni";
    private static final String errorMsg = "Unsupported OS/arch, cannot find " + Native.resourceName() + " or load " + "zstd-jni" + " from system libraries. Please try building from source the jar or providing " + "libzstd-jni" + " in your system.";
    private static boolean loaded = false;

    private static String osName() {
        String os = System.getProperty("os.name").toLowerCase().replace(' ', '_');
        if (os.startsWith("win")) {
            return "win";
        }
        if (os.startsWith("mac")) {
            return "darwin";
        }
        return os;
    }

    private static String osArch() {
        return System.getProperty("os.arch");
    }

    private static String libExtension() {
        if (Native.osName().contains("os_x") || Native.osName().contains("darwin")) {
            return "dylib";
        }
        if (Native.osName().contains("win")) {
            return "dll";
        }
        return "so";
    }

    private static String resourceName() {
        return "/" + Native.osName() + "/" + Native.osArch() + "/" + libname + "." + Native.libExtension();
    }

    public static synchronized boolean isLoaded() {
        return loaded;
    }

    private static UnsatisfiedLinkError linkError(UnsatisfiedLinkError e) {
        UnsatisfiedLinkError err = new UnsatisfiedLinkError(e.getMessage() + "\n" + errorMsg);
        err.setStackTrace(e.getStackTrace());
        return err;
    }

    public static synchronized void load() {
        Native.load(null);
    }

    public static synchronized void load(File tempFolder) {
        if (loaded) {
            return;
        }
        String resourceName = Native.resourceName();
        InputStream is = Native.class.getResourceAsStream(resourceName);
        if (is == null) {
            try {
                System.loadLibrary(libnameShort);
                loaded = true;
                return;
            }
            catch (UnsatisfiedLinkError e) {
                throw Native.linkError(e);
            }
        }
        File tempLib = null;
        FileOutputStream out = null;
        try {
            int read22;
            tempLib = File.createTempFile(libname, "." + Native.libExtension(), tempFolder);
            tempLib.deleteOnExit();
            out = new FileOutputStream(tempLib);
            byte[] buf = new byte[4096];
            while ((read22 = is.read(buf)) != -1) {
                out.write(buf, 0, read22);
            }
            try {
                out.flush();
                out.close();
                out = null;
            }
            catch (IOException read22) {
                // empty catch block
            }
            try {
                System.load(tempLib.getAbsolutePath());
            }
            catch (UnsatisfiedLinkError e) {
                try {
                    System.loadLibrary(libnameShort);
                }
                catch (UnsatisfiedLinkError e1) {
                    throw Native.linkError(e1);
                }
            }
            loaded = true;
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError("Cannot unpack libzstd-jni");
        }
        finally {
            try {
                is.close();
                if (out != null) {
                    out.close();
                }
                if (tempLib != null && tempLib.exists()) {
                    tempLib.delete();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

