/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class AutoCloseBase
implements Closeable {
    private static final AtomicIntegerFieldUpdater<AutoCloseBase> SHARED_LOCK_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AutoCloseBase.class, "sharedLock");
    private static final int SHARED_LOCK_CLOSED = -1;
    private boolean finalize = true;
    private volatile int sharedLock;

    AutoCloseBase() {
    }

    public void setFinalize(boolean finalize) {
        this.finalize = finalize;
    }

    void storeFence() {
        this.sharedLock = 0;
    }

    void acquireSharedLock() {
        int sharedLock;
        do {
            if ((sharedLock = this.sharedLock) < 0) {
                throw new IllegalStateException("Closed");
            }
            if (sharedLock != Integer.MAX_VALUE) continue;
            throw new IllegalStateException("Shared lock overflow");
        } while (!SHARED_LOCK_UPDATER.compareAndSet(this, sharedLock, sharedLock + 1));
    }

    void releaseSharedLock() {
        int sharedLock;
        do {
            if ((sharedLock = this.sharedLock) < 0) {
                throw new IllegalStateException("Closed");
            }
            if (sharedLock != 0) continue;
            throw new IllegalStateException("Shared lock underflow");
        } while (!SHARED_LOCK_UPDATER.compareAndSet(this, sharedLock, sharedLock - 1));
    }

    abstract void doClose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AutoCloseBase autoCloseBase = this;
        synchronized (autoCloseBase) {
            if (this.sharedLock == -1) {
                return;
            }
            if (!SHARED_LOCK_UPDATER.compareAndSet(this, 0, -1)) {
                throw new IllegalStateException("Attempt to close while in use");
            }
            this.doClose();
        }
    }

    protected void finalize() {
        if (this.finalize) {
            this.close();
        }
    }
}

