/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

class BufferPool {
    private static final Map<Integer, SoftReference<BufferPool>> pools = new HashMap<Integer, SoftReference<BufferPool>>();
    private final int length;
    private final Deque<byte[]> queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BufferPool get(int length) {
        Map<Integer, SoftReference<BufferPool>> map = pools;
        synchronized (map) {
            BufferPool pool;
            SoftReference<BufferPool> poolReference = pools.get(length);
            if (poolReference == null || (pool = poolReference.get()) == null) {
                pool = new BufferPool(length);
                poolReference = new SoftReference<BufferPool>(pool);
                pools.put(length, poolReference);
            }
            return pool;
        }
    }

    BufferPool(int length) {
        this.length = length;
        this.queue = new ArrayDeque<byte[]>();
    }

    synchronized byte[] checkOut() {
        byte[] buffer = this.queue.pollFirst();
        if (buffer == null) {
            buffer = new byte[this.length];
        }
        return buffer;
    }

    synchronized void checkIn(byte[] buffer) {
        if (this.length != buffer.length) {
            throw new IllegalStateException("buffer size mismatch");
        }
        this.queue.addLast(buffer);
    }
}

