/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.BufferPool;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class RecyclingBufferPool
implements BufferPool {
    public static final BufferPool INSTANCE = new RecyclingBufferPool();
    private final Map<Integer, SoftReference<Deque<ByteBuffer>>> pools = new HashMap<Integer, SoftReference<Deque<ByteBuffer>>>();

    private RecyclingBufferPool() {
    }

    private Deque<ByteBuffer> getDeque(int capacity) {
        ArrayDeque<ByteBuffer> deque;
        SoftReference<Deque<ByteBuffer>> dequeReference = this.pools.get(capacity);
        if (dequeReference == null || (deque = dequeReference.get()) == null) {
            deque = new ArrayDeque();
            dequeReference = new SoftReference<ArrayDeque<ByteBuffer>>(deque);
            this.pools.put(capacity, dequeReference);
        }
        return deque;
    }

    @Override
    public synchronized ByteBuffer get(int capacity) {
        ByteBuffer buffer = this.getDeque(capacity).pollFirst();
        if (buffer == null) {
            buffer = ByteBuffer.allocate(capacity);
        }
        return buffer;
    }

    @Override
    public synchronized void release(ByteBuffer buffer) {
        this.getDeque(buffer.capacity()).addLast(buffer);
    }
}

