/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.ZstdInputStreamBase;
import com.github.luben.zstd.ZstdOutputStreamBase;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;

public class RecyclingBufferPool
implements BufferPool {
    public static final BufferPool INSTANCE = new RecyclingBufferPool();
    private static final int buffSize = Math.max(Math.max((int)ZstdOutputStreamBase.recommendedCOutSize(), (int)ZstdInputStreamBase.recommendedDInSize()), (int)ZstdInputStreamBase.recommendedDOutSize());
    private final ArrayDeque<SoftReference<ByteBuffer>> pool = new ArrayDeque();

    private RecyclingBufferPool() {
    }

    @Override
    public synchronized ByteBuffer get(int n) {
        SoftReference<ByteBuffer> softReference;
        ByteBuffer byteBuffer;
        if (n > buffSize) {
            throw new RuntimeException("Unsupported buffer size: " + n + ". Supported buffer sizes: " + buffSize + " or smaller.");
        }
        do {
            if ((softReference = this.pool.pollFirst()) != null) continue;
            return ByteBuffer.allocate(buffSize);
        } while ((byteBuffer = softReference.get()) == null);
        return byteBuffer;
    }

    @Override
    public synchronized void release(ByteBuffer byteBuffer) {
        if (byteBuffer.capacity() >= buffSize) {
            byteBuffer.clear();
            this.pool.addFirst(new SoftReference<ByteBuffer>(byteBuffer));
        }
    }
}

