/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.NoPool;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.util.Native;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class ZstdOutputStreamNoFinalizer
extends FilterOutputStream {
    private final long stream = ZstdOutputStreamNoFinalizer.createCStream();
    private long srcPos = 0L;
    private long dstPos = 0L;
    private final BufferPool bufferPool;
    private final ByteBuffer dstByteBuffer;
    private final byte[] dst;
    private boolean isClosed = false;
    private static final int dstSize;
    private boolean closeFrameOnFlush = false;
    private boolean frameClosed = true;

    public static native long recommendedCOutSize();

    private static native long createCStream();

    private static native int freeCStream(long var0);

    private native int resetCStream(long var1);

    private native int compressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    private native int flushStream(long var1, byte[] var3, int var4);

    private native int endStream(long var1, byte[] var3, int var4);

    public ZstdOutputStreamNoFinalizer(OutputStream outStream, int level) throws IOException {
        this(outStream, NoPool.INSTANCE);
        Zstd.setCompressionLevel(this.stream, level);
    }

    public ZstdOutputStreamNoFinalizer(OutputStream outStream) throws IOException {
        this(outStream, NoPool.INSTANCE);
    }

    public ZstdOutputStreamNoFinalizer(OutputStream outStream, BufferPool bufferPool, int level) throws IOException {
        this(outStream, bufferPool);
        Zstd.setCompressionLevel(this.stream, level);
    }

    public ZstdOutputStreamNoFinalizer(OutputStream outStream, BufferPool bufferPool) throws IOException {
        super(outStream);
        this.bufferPool = bufferPool;
        this.dstByteBuffer = bufferPool.get(dstSize);
        if (this.dstByteBuffer == null) {
            throw new IOException("Cannot get ByteBuffer of size " + dstSize + " from the BufferPool");
        }
        this.dst = Zstd.extractArray(this.dstByteBuffer);
    }

    public synchronized ZstdOutputStreamNoFinalizer setChecksum(boolean useChecksums) throws IOException {
        if (!this.frameClosed) {
            throw new IOException("Change of parameter on initialized stream");
        }
        int size = Zstd.setCompressionChecksums(this.stream, useChecksums);
        if (Zstd.isError(size)) {
            throw new IOException("Compression param: " + Zstd.getErrorName(size));
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setLevel(int level) throws IOException {
        if (!this.frameClosed) {
            throw new IOException("Change of parameter on initialized stream");
        }
        int size = Zstd.setCompressionLevel(this.stream, level);
        if (Zstd.isError(size)) {
            throw new IOException("Compression param: " + Zstd.getErrorName(size));
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setWorkers(int n) throws IOException {
        if (!this.frameClosed) {
            throw new IOException("Change of parameter on initialized stream");
        }
        int size = Zstd.setCompressionWorkers(this.stream, n);
        if (Zstd.isError(size)) {
            throw new IOException("Compression param: " + Zstd.getErrorName(size));
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setCloseFrameOnFlush(boolean closeOnFlush) throws IOException {
        if (!this.frameClosed) {
            throw new IOException("Change of parameter on initialized stream");
        }
        this.closeFrameOnFlush = closeOnFlush;
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setDict(byte[] dict) throws IOException {
        if (!this.frameClosed) {
            throw new IOException("Change of parameter on initialized stream");
        }
        int size = Zstd.loadDictCompress(this.stream, dict, dict.length);
        if (Zstd.isError(size)) {
            throw new IOException("Compression param: " + Zstd.getErrorName(size));
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setDict(ZstdDictCompress dict) throws IOException {
        if (!this.frameClosed) {
            throw new IOException("Change of parameter on initialized stream");
        }
        int size = Zstd.loadFastDictCompress(this.stream, dict);
        if (Zstd.isError(size)) {
            throw new IOException("Compression param: " + Zstd.getErrorName(size));
        }
        return this;
    }

    @Override
    public synchronized void write(byte[] src, int offset, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (this.frameClosed) {
            int size = this.resetCStream(this.stream);
            if (Zstd.isError(size)) {
                throw new IOException("Compression error: cannot create header: " + Zstd.getErrorName(size));
            }
            this.frameClosed = false;
        }
        int srcSize = offset + len;
        this.srcPos = offset;
        while (this.srcPos < (long)srcSize) {
            int size = this.compressStream(this.stream, this.dst, dstSize, src, srcSize);
            if (Zstd.isError(size)) {
                throw new IOException("Compression error: " + Zstd.getErrorName(size));
            }
            if (this.dstPos <= 0L) continue;
            this.out.write(this.dst, 0, (int)this.dstPos);
        }
    }

    @Override
    public void write(int i) throws IOException {
        byte[] oneByte = new byte[]{(byte)i};
        this.write(oneByte, 0, 1);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (!this.frameClosed) {
            if (this.closeFrameOnFlush) {
                int size;
                do {
                    if (Zstd.isError(size = this.endStream(this.stream, this.dst, dstSize))) {
                        throw new IOException("Compression error: " + Zstd.getErrorName(size));
                    }
                    this.out.write(this.dst, 0, (int)this.dstPos);
                } while (size > 0);
                this.frameClosed = true;
            } else {
                int size;
                do {
                    if (Zstd.isError(size = this.flushStream(this.stream, this.dst, dstSize))) {
                        throw new IOException("Compression error: " + Zstd.getErrorName(size));
                    }
                    this.out.write(this.dst, 0, (int)this.dstPos);
                } while (size > 0);
            }
            this.out.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            if (!this.frameClosed) {
                int size;
                do {
                    if (Zstd.isError(size = this.endStream(this.stream, this.dst, dstSize))) {
                        throw new IOException("Compression error: " + Zstd.getErrorName(size));
                    }
                    this.out.write(this.dst, 0, (int)this.dstPos);
                } while (size > 0);
            }
            this.out.close();
        }
        finally {
            this.isClosed = true;
            this.bufferPool.release(this.dstByteBuffer);
            ZstdOutputStreamNoFinalizer.freeCStream(this.stream);
        }
    }

    static {
        Native.load();
        dstSize = (int)ZstdOutputStreamNoFinalizer.recommendedCOutSize();
    }
}

