/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZstdInputStream
extends FilterInputStream {
    private ZstdInputStreamNoFinalizer inner;

    public ZstdInputStream(InputStream inStream) throws IOException {
        super(inStream);
        this.inner = new ZstdInputStreamNoFinalizer(inStream);
    }

    public ZstdInputStream(InputStream inStream, BufferPool bufferPool) throws IOException {
        super(inStream);
        this.inner = new ZstdInputStreamNoFinalizer(inStream, bufferPool);
    }

    public void setFinalize(boolean finalize) {
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static long recommendedDInSize() {
        return ZstdInputStreamNoFinalizer.recommendedDInSize();
    }

    public static long recommendedDOutSize() {
        return ZstdInputStreamNoFinalizer.recommendedDOutSize();
    }

    public ZstdInputStream setContinuous(boolean b) {
        this.inner.setContinuous(b);
        return this;
    }

    public boolean getContinuous() {
        return this.inner.getContinuous();
    }

    public ZstdInputStream setDict(byte[] dict) throws IOException {
        this.inner.setDict(dict);
        return this;
    }

    public ZstdInputStream setDict(ZstdDictDecompress dict) throws IOException {
        this.inner.setDict(dict);
        return this;
    }

    @Override
    public int read(byte[] dst, int offset, int len) throws IOException {
        return this.inner.read(dst, offset, len);
    }

    @Override
    public int read() throws IOException {
        return this.inner.read();
    }

    @Override
    public int available() throws IOException {
        return this.inner.available();
    }

    @Override
    public long skip(long numBytes) throws IOException {
        return this.inner.skip(numBytes);
    }

    @Override
    public boolean markSupported() {
        return this.inner.markSupported();
    }

    @Override
    public void close() throws IOException {
        this.inner.close();
    }
}

