/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.util.Native;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZstdDirectBufferCompressingStream
implements Closeable,
Flushable {
    private ByteBuffer target;
    private final long stream;
    private int consumed = 0;
    private int produced = 0;
    private boolean closed = false;
    private boolean initialized = false;
    private boolean finalize = true;
    private int level = Zstd.defaultCompressionLevel();
    private byte[] dict = null;
    private ZstdDictCompress fastDict = null;

    protected ByteBuffer flushBuffer(ByteBuffer toFlush) throws IOException {
        return toFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdDirectBufferCompressingStream(ByteBuffer target, int level) throws IOException {
        if (!target.isDirect()) {
            throw new IllegalArgumentException("Target buffer should be a direct buffer");
        }
        ZstdDirectBufferCompressingStream zstdDirectBufferCompressingStream = this;
        synchronized (zstdDirectBufferCompressingStream) {
            this.target = target;
            this.level = level;
            this.stream = ZstdDirectBufferCompressingStream.createCStream();
        }
    }

    public static int recommendedOutputBufferSize() {
        return (int)ZstdDirectBufferCompressingStream.recommendedCOutSize();
    }

    private static native long recommendedCOutSize();

    private static native long createCStream();

    private static native int freeCStream(long var0);

    private native int initCStream(long var1, int var3);

    private native int initCStreamWithDict(long var1, byte[] var3, int var4, int var5);

    private native int initCStreamWithFastDict(long var1, ZstdDictCompress var3);

    private native int compressDirectByteBuffer(long var1, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8);

    private native int flushStream(long var1, ByteBuffer var3, int var4, int var5);

    private native int endStream(long var1, ByteBuffer var3, int var4, int var5);

    public synchronized ZstdDirectBufferCompressingStream setDict(byte[] dict) throws IOException {
        if (this.initialized) {
            throw new IOException("Change of parameter on initialized stream");
        }
        this.dict = dict;
        this.fastDict = null;
        return this;
    }

    public synchronized ZstdDirectBufferCompressingStream setDict(ZstdDictCompress dict) throws IOException {
        if (this.initialized) {
            throw new IOException("Change of parameter on initialized stream");
        }
        this.dict = null;
        this.fastDict = dict;
        return this;
    }

    public void setFinalize(boolean finalize) {
        this.finalize = finalize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void compress(ByteBuffer source) throws IOException {
        int result;
        if (!source.isDirect()) {
            throw new IllegalArgumentException("Source buffer should be a direct buffer");
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (!this.initialized) {
            result = 0;
            ZstdDictCompress fastDict = this.fastDict;
            if (fastDict != null) {
                fastDict.acquireSharedLock();
                try {
                    result = this.initCStreamWithFastDict(this.stream, fastDict);
                }
                finally {
                    fastDict.releaseSharedLock();
                }
            } else {
                result = this.dict != null ? this.initCStreamWithDict(this.stream, this.dict, this.dict.length, this.level) : this.initCStream(this.stream, this.level);
            }
            if (Zstd.isError(result)) {
                throw new IOException("Compression error: cannot create header: " + Zstd.getErrorName(result));
            }
            this.initialized = true;
        }
        while (source.hasRemaining()) {
            if (!this.target.hasRemaining()) {
                this.target = this.flushBuffer(this.target);
                if (!this.target.isDirect()) {
                    throw new IllegalArgumentException("Target buffer should be a direct buffer");
                }
                if (!this.target.hasRemaining()) {
                    throw new IOException("The target buffer has no more space, even after flushing, and there are still bytes to compress");
                }
            }
            if (Zstd.isError(result = this.compressDirectByteBuffer(this.stream, this.target, this.target.position(), this.target.remaining(), source, source.position(), source.remaining()))) {
                throw new IOException("Compression error: " + Zstd.getErrorName(result));
            }
            this.target.position(this.target.position() + this.produced);
            source.position(source.position() + this.consumed);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        if (this.initialized) {
            int needed;
            do {
                if (Zstd.isError(needed = this.flushStream(this.stream, this.target, this.target.position(), this.target.remaining()))) {
                    throw new IOException("Compression error: " + Zstd.getErrorName(needed));
                }
                this.target.position(this.target.position() + this.produced);
                this.target = this.flushBuffer(this.target);
                if (!this.target.isDirect()) {
                    throw new IllegalArgumentException("Target buffer should be a direct buffer");
                }
                if (needed <= 0 || this.target.hasRemaining()) continue;
                throw new IOException("The target buffer has no more space, even after flushing, and there are still bytes to compress");
            } while (needed > 0);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            try {
                if (this.initialized) {
                    int needed;
                    do {
                        if (Zstd.isError(needed = this.endStream(this.stream, this.target, this.target.position(), this.target.remaining()))) {
                            throw new IOException("Compression error: " + Zstd.getErrorName(needed));
                        }
                        this.target.position(this.target.position() + this.produced);
                        this.target = this.flushBuffer(this.target);
                        if (!this.target.isDirect()) {
                            throw new IllegalArgumentException("Target buffer should be a direct buffer");
                        }
                        if (needed <= 0 || this.target.hasRemaining()) continue;
                        throw new IOException("The target buffer has no more space, even after flushing, and there are still bytes to compress");
                    } while (needed > 0);
                }
            }
            finally {
                ZstdDirectBufferCompressingStream.freeCStream(this.stream);
                this.closed = true;
                this.initialized = false;
                this.target = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.finalize) {
            this.close();
        }
    }

    static {
        Native.load();
    }
}

