/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.AutoCloseBase;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ZstdDecompressCtx
extends AutoCloseBase {
    private long nativePtr = 0L;
    private ZstdDictDecompress decompression_dict = null;

    private native void init();

    private native void free();

    public ZstdDecompressCtx() {
        this.init();
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createDeCompressCtx failed");
        }
        this.storeFence();
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            this.free();
            this.nativePtr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdDecompressCtx loadDict(ZstdDictDecompress dict) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Decompression context is closed");
        }
        this.acquireSharedLock();
        dict.acquireSharedLock();
        try {
            long result = this.loadDDictFast0(dict);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            this.decompression_dict = dict;
        }
        finally {
            dict.releaseSharedLock();
            this.releaseSharedLock();
        }
        return this;
    }

    private native long loadDDictFast0(ZstdDictDecompress var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdDecompressCtx loadDict(byte[] dict) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        try {
            long result = this.loadDDict0(dict);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            this.decompression_dict = null;
        }
        finally {
            this.releaseSharedLock();
        }
        return this;
    }

    private native long loadDDict0(byte[] var1);

    public void reset() {
        this.ensureOpen();
        this.reset0();
    }

    private native void reset0();

    private void ensureOpen() {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Decompression context is closed");
        }
    }

    public boolean decompressDirectByteBufferStream(ByteBuffer dst, ByteBuffer src) {
        this.ensureOpen();
        long result = this.decompressDirectByteBufferStream0(dst, dst.position(), dst.limit(), src, src.position(), src.limit());
        if ((result & 0x80000000L) != 0L) {
            long code = result & 0xFFL;
            throw new ZstdException(code, Zstd.getErrorName(code));
        }
        src.position((int)(result & Integer.MAX_VALUE));
        dst.position((int)(result >>> 32) & Integer.MAX_VALUE);
        return result >>> 63 == 1L;
    }

    private native long decompressDirectByteBufferStream0(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decompressDirectByteBuffer(ByteBuffer dstBuff, int dstOffset, int dstSize, ByteBuffer srcBuff, int srcOffset, int srcSize) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Decompression context is closed");
        }
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!dstBuff.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        this.acquireSharedLock();
        try {
            long size = this.decompressDirectByteBuffer0(dstBuff, dstOffset, dstSize, srcBuff, srcOffset, srcSize);
            if (Zstd.isError(size)) {
                throw new ZstdException(size);
            }
            if (size > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)size;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long decompressDirectByteBuffer0(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decompressByteArray(byte[] dstBuff, int dstOffset, int dstSize, byte[] srcBuff, int srcOffset, int srcSize) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Decompression context is closed");
        }
        this.acquireSharedLock();
        try {
            long size = this.decompressByteArray0(dstBuff, dstOffset, dstSize, srcBuff, srcOffset, srcSize);
            if (Zstd.isError(size)) {
                throw new ZstdException(size);
            }
            if (size > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)size;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long decompressByteArray0(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    public int decompress(ByteBuffer dstBuf, ByteBuffer srcBuf) throws ZstdException {
        int size = this.decompressDirectByteBuffer(dstBuf, dstBuf.position(), dstBuf.limit() - dstBuf.position(), srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position());
        srcBuf.position(srcBuf.limit());
        dstBuf.position(dstBuf.position() + size);
        return size;
    }

    public ByteBuffer decompress(ByteBuffer srcBuf, int originalSize) throws ZstdException {
        ByteBuffer dstBuf = ByteBuffer.allocateDirect(originalSize);
        int size = this.decompressDirectByteBuffer(dstBuf, 0, originalSize, srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position());
        srcBuf.position(srcBuf.limit());
        return dstBuf;
    }

    public int decompress(byte[] dst, byte[] src) {
        return this.decompressByteArray(dst, 0, dst.length, src, 0, src.length);
    }

    public byte[] decompress(byte[] src, int originalSize) throws ZstdException {
        byte[] dst = new byte[originalSize];
        int size = this.decompress(dst, src);
        if (size != originalSize) {
            return Arrays.copyOfRange(dst, 0, size);
        }
        return dst;
    }

    static {
        Native.load();
    }
}

