/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.ZstdIOException;
import com.github.luben.zstd.util.Native;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZstdDirectBufferDecompressingStreamNoFinalizer
implements Closeable {
    private ByteBuffer source;
    private final long stream;
    private boolean finishedFrame = false;
    private boolean closed = false;
    private boolean streamEnd = false;
    private int consumed;
    private int produced;

    protected ByteBuffer refill(ByteBuffer toRefill) {
        return toRefill;
    }

    private static native long recommendedDOutSize();

    private static native long createDStream();

    private static native long freeDStream(long var0);

    private native long initDStream(long var1);

    private native long decompressStream(long var1, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8);

    public ZstdDirectBufferDecompressingStreamNoFinalizer(ByteBuffer source) {
        if (!source.isDirect()) {
            throw new IllegalArgumentException("Source buffer should be a direct buffer");
        }
        this.source = source;
        this.stream = ZstdDirectBufferDecompressingStreamNoFinalizer.createDStream();
        this.initDStream(this.stream);
    }

    public boolean hasRemaining() {
        return !this.streamEnd && (this.source.hasRemaining() || !this.finishedFrame);
    }

    public static int recommendedTargetBufferSize() {
        return (int)ZstdDirectBufferDecompressingStreamNoFinalizer.recommendedDOutSize();
    }

    public ZstdDirectBufferDecompressingStreamNoFinalizer setDict(byte[] dict) throws IOException {
        long size = Zstd.loadDictDecompress(this.stream, dict, dict.length);
        if (Zstd.isError(size)) {
            throw new ZstdIOException(size);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdDirectBufferDecompressingStreamNoFinalizer setDict(ZstdDictDecompress dict) throws IOException {
        dict.acquireSharedLock();
        try {
            long size = Zstd.loadFastDictDecompress(this.stream, dict);
            if (Zstd.isError(size)) {
                throw new ZstdIOException(size);
            }
        }
        finally {
            dict.releaseSharedLock();
        }
        return this;
    }

    public ZstdDirectBufferDecompressingStreamNoFinalizer setLongMax(int windowLogMax) throws IOException {
        long size = Zstd.setDecompressionLongMax(this.stream, windowLogMax);
        if (Zstd.isError(size)) {
            throw new ZstdIOException(size);
        }
        return this;
    }

    public int read(ByteBuffer target) throws IOException {
        if (!target.isDirect()) {
            throw new IllegalArgumentException("Target buffer should be a direct buffer");
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.streamEnd) {
            return 0;
        }
        long remaining = this.decompressStream(this.stream, target, target.position(), target.remaining(), this.source, this.source.position(), this.source.remaining());
        if (Zstd.isError(remaining)) {
            throw new ZstdIOException(remaining);
        }
        this.source.position(this.source.position() + this.consumed);
        target.position(target.position() + this.produced);
        if (!this.source.hasRemaining()) {
            this.source = this.refill(this.source);
            if (!this.source.isDirect()) {
                throw new IllegalArgumentException("Source buffer should be a direct buffer");
            }
        }
        boolean bl = this.finishedFrame = remaining == 0L;
        if (this.finishedFrame) {
            this.streamEnd = !this.source.hasRemaining();
        }
        return this.produced;
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                ZstdDirectBufferDecompressingStreamNoFinalizer.freeDStream(this.stream);
            }
            finally {
                this.closed = true;
                this.source = null;
            }
        }
    }

    static {
        Native.load();
    }
}

