/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.BaseZstdBufferDecompressingStreamNoFinalizer;
import com.github.luben.zstd.util.Native;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZstdDirectBufferDecompressingStreamNoFinalizer
extends BaseZstdBufferDecompressingStreamNoFinalizer {
    public ZstdDirectBufferDecompressingStreamNoFinalizer(ByteBuffer source) {
        super(source);
        if (!source.isDirect()) {
            throw new IllegalArgumentException("Source buffer should be a direct buffer");
        }
        this.source = source;
        this.stream = ZstdDirectBufferDecompressingStreamNoFinalizer.createDStreamNative();
        this.initDStreamNative(this.stream);
    }

    @Override
    public int read(ByteBuffer target) throws IOException {
        if (!target.isDirect()) {
            throw new IllegalArgumentException("Target buffer should be a direct buffer");
        }
        return this.readInternal(target, true);
    }

    @Override
    long createDStream() {
        return ZstdDirectBufferDecompressingStreamNoFinalizer.createDStreamNative();
    }

    @Override
    long freeDStream(long stream) {
        return ZstdDirectBufferDecompressingStreamNoFinalizer.freeDStreamNative(stream);
    }

    @Override
    long initDStream(long stream) {
        return this.initDStreamNative(stream);
    }

    @Override
    long decompressStream(long stream, ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize) {
        return this.decompressStreamNative(stream, dst, dstOffset, dstSize, src, srcOffset, srcSize);
    }

    public static int recommendedTargetBufferSize() {
        return (int)ZstdDirectBufferDecompressingStreamNoFinalizer.recommendedDOutSizeNative();
    }

    private static native long createDStreamNative();

    private static native long freeDStreamNative(long var0);

    private native long initDStreamNative(long var1);

    private native long decompressStreamNative(long var1, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8);

    private static native long recommendedDOutSizeNative();

    static {
        Native.load();
    }
}

