/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.AutoCloseBase;
import com.github.luben.zstd.EndDirective;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.ZstdFrameProgression;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ZstdCompressCtx
extends AutoCloseBase {
    private long nativePtr = ZstdCompressCtx.init();
    private ZstdDictCompress compression_dict = null;

    private static native long init();

    private static native void free(long var0);

    public ZstdCompressCtx() {
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createCompressCtx failed");
        }
        this.storeFence();
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            ZstdCompressCtx.free(this.nativePtr);
            this.nativePtr = 0L;
        }
    }

    private void ensureOpen() {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
    }

    public ZstdCompressCtx setLevel(int level) {
        this.ensureOpen();
        this.acquireSharedLock();
        ZstdCompressCtx.setLevel0(this.nativePtr, level);
        this.releaseSharedLock();
        return this;
    }

    private static native void setLevel0(long var0, int var2);

    public ZstdCompressCtx setMagicless(boolean magiclessFlag) {
        this.ensureOpen();
        this.acquireSharedLock();
        Zstd.setCompressionMagicless(this.nativePtr, magiclessFlag);
        this.releaseSharedLock();
        return this;
    }

    public ZstdCompressCtx setChecksum(boolean checksumFlag) {
        this.ensureOpen();
        this.acquireSharedLock();
        ZstdCompressCtx.setChecksum0(this.nativePtr, checksumFlag);
        this.releaseSharedLock();
        return this;
    }

    private static native void setChecksum0(long var0, boolean var2);

    public ZstdCompressCtx setWorkers(int workers) {
        this.ensureOpen();
        this.acquireSharedLock();
        Zstd.setCompressionWorkers(this.nativePtr, workers);
        this.releaseSharedLock();
        return this;
    }

    public ZstdCompressCtx setContentSize(boolean contentSizeFlag) {
        this.ensureOpen();
        this.acquireSharedLock();
        ZstdCompressCtx.setContentSize0(this.nativePtr, contentSizeFlag);
        this.releaseSharedLock();
        return this;
    }

    private static native void setContentSize0(long var0, boolean var2);

    public ZstdCompressCtx setDictID(boolean dictIDFlag) {
        this.ensureOpen();
        this.acquireSharedLock();
        ZstdCompressCtx.setDictID0(this.nativePtr, dictIDFlag);
        this.releaseSharedLock();
        return this;
    }

    private static native void setDictID0(long var0, boolean var2);

    public ZstdCompressCtx setLong(int windowLog) {
        this.ensureOpen();
        this.acquireSharedLock();
        Zstd.setCompressionLong(this.nativePtr, windowLog);
        this.releaseSharedLock();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdCompressCtx loadDict(ZstdDictCompress dict) {
        this.ensureOpen();
        this.acquireSharedLock();
        dict.acquireSharedLock();
        try {
            long result = this.loadCDictFast0(this.nativePtr, dict);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            this.compression_dict = dict;
        }
        finally {
            dict.releaseSharedLock();
            this.releaseSharedLock();
        }
        return this;
    }

    private native long loadCDictFast0(long var1, ZstdDictCompress var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdCompressCtx loadDict(byte[] dict) {
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long result = this.loadCDict0(this.nativePtr, dict);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            this.compression_dict = null;
        }
        finally {
            this.releaseSharedLock();
        }
        return this;
    }

    private native long loadCDict0(long var1, byte[] var3);

    public ZstdFrameProgression getFrameProgression() {
        this.ensureOpen();
        return ZstdCompressCtx.getFrameProgression0(this.nativePtr);
    }

    private static native ZstdFrameProgression getFrameProgression0(long var0);

    public void reset() {
        this.ensureOpen();
        long result = ZstdCompressCtx.reset0(this.nativePtr);
        if (Zstd.isError(result)) {
            throw new ZstdException(result);
        }
    }

    private static native long reset0(long var0);

    public void setPledgedSrcSize(long srcSize) {
        this.ensureOpen();
        long result = ZstdCompressCtx.setPledgedSrcSize0(this.nativePtr, srcSize);
        if (Zstd.isError(result)) {
            throw new ZstdException(result);
        }
    }

    private static native long setPledgedSrcSize0(long var0, long var2);

    public boolean compressDirectByteBufferStream(ByteBuffer dst, ByteBuffer src, EndDirective endOp) {
        this.ensureOpen();
        long result = ZstdCompressCtx.compressDirectByteBufferStream0(this.nativePtr, dst, dst.position(), dst.limit(), src, src.position(), src.limit(), endOp.value());
        if ((result & 0x80000000L) != 0L) {
            long code = result & 0xFFL;
            throw new ZstdException(code, Zstd.getErrorName(code));
        }
        src.position((int)(result & Integer.MAX_VALUE));
        dst.position((int)(result >>> 32) & Integer.MAX_VALUE);
        return result >>> 63 == 1L;
    }

    private static native long compressDirectByteBufferStream0(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compressDirectByteBuffer(ByteBuffer dstBuff, int dstOffset, int dstSize, ByteBuffer srcBuff, int srcOffset, int srcSize) {
        this.ensureOpen();
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!dstBuff.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        this.acquireSharedLock();
        try {
            long size = ZstdCompressCtx.compressDirectByteBuffer0(this.nativePtr, dstBuff, dstOffset, dstSize, srcBuff, srcOffset, srcSize);
            if (Zstd.isError(size)) {
                throw new ZstdException(size);
            }
            if (size > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)size;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long compressDirectByteBuffer0(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compressByteArray(byte[] dstBuff, int dstOffset, int dstSize, byte[] srcBuff, int srcOffset, int srcSize) {
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long size = ZstdCompressCtx.compressByteArray0(this.nativePtr, dstBuff, dstOffset, dstSize, srcBuff, srcOffset, srcSize);
            if (Zstd.isError(size)) {
                throw new ZstdException(size);
            }
            if (size > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)size;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long compressByteArray0(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7);

    public int compress(ByteBuffer dstBuf, ByteBuffer srcBuf) {
        int size = this.compressDirectByteBuffer(dstBuf, dstBuf.position(), dstBuf.limit() - dstBuf.position(), srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position());
        srcBuf.position(srcBuf.limit());
        dstBuf.position(dstBuf.position() + size);
        return size;
    }

    public ByteBuffer compress(ByteBuffer srcBuf) throws ZstdException {
        long maxDstSize = Zstd.compressBound(srcBuf.limit() - srcBuf.position());
        if (maxDstSize > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        ByteBuffer dstBuf = ByteBuffer.allocateDirect((int)maxDstSize);
        int size = this.compressDirectByteBuffer(dstBuf, 0, (int)maxDstSize, srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position());
        srcBuf.position(srcBuf.limit());
        dstBuf.limit(size);
        return dstBuf;
    }

    public int compress(byte[] dst, byte[] src) {
        return this.compressByteArray(dst, 0, dst.length, src, 0, src.length);
    }

    public byte[] compress(byte[] src) {
        long maxDstSize = Zstd.compressBound(src.length);
        if (maxDstSize > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        byte[] dst = new byte[(int)maxDstSize];
        int size = this.compressByteArray(dst, 0, dst.length, src, 0, src.length);
        return Arrays.copyOfRange(dst, 0, size);
    }

    static {
        Native.load();
    }
}

