/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.SharedDictBase;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;

public class ZstdDictDecompress
extends SharedDictBase {
    private long nativePtr = 0L;

    private native void init(byte[] var1, int var2, int var3);

    private native void initDirect(ByteBuffer var1, int var2, int var3);

    private native void free();

    public ZstdDictDecompress(byte[] dict) {
        this(dict, 0, dict.length);
    }

    public ZstdDictDecompress(byte[] dict, int offset, int length) {
        this.init(dict, offset, length);
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("ZSTD_createDDict failed");
        }
        this.storeFence();
    }

    public ZstdDictDecompress(ByteBuffer dict) {
        int length = dict.limit() - dict.position();
        if (!dict.isDirect()) {
            throw new IllegalArgumentException("dict must be a direct buffer");
        }
        if (length < 0) {
            throw new IllegalArgumentException("dict cannot be empty.");
        }
        this.initDirect(dict, dict.position(), length);
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("ZSTD_createDDict failed");
        }
        this.storeFence();
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            this.free();
            this.nativePtr = 0L;
        }
    }

    static {
        Native.load();
    }
}

