/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.BaseZstdBufferDecompressingStreamNoFinalizer;
import com.github.luben.zstd.util.Native;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZstdBufferDecompressingStreamNoFinalizer
extends BaseZstdBufferDecompressingStreamNoFinalizer {
    public ZstdBufferDecompressingStreamNoFinalizer(ByteBuffer source) {
        super(source);
        if (source.isDirect()) {
            throw new IllegalArgumentException("Source buffer should be a non-direct buffer");
        }
        this.stream = this.createDStream();
        this.initDStream(this.stream);
    }

    @Override
    public int read(ByteBuffer target) throws IOException {
        if (target.isDirect()) {
            throw new IllegalArgumentException("Target buffer should be a non-direct buffer");
        }
        return this.readInternal(target, false);
    }

    @Override
    long createDStream() {
        return this.createDStreamNative();
    }

    @Override
    long freeDStream(long stream) {
        return this.freeDStreamNative(stream);
    }

    @Override
    long initDStream(long stream) {
        return this.initDStreamNative(stream);
    }

    @Override
    long decompressStream(long stream, ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize) {
        if (!src.hasArray()) {
            throw new IllegalArgumentException("provided source ByteBuffer lacks array");
        }
        if (!dst.hasArray()) {
            throw new IllegalArgumentException("provided destination ByteBuffer lacks array");
        }
        byte[] targetArr = dst.array();
        byte[] sourceArr = src.array();
        return this.decompressStreamNative(stream, targetArr, dstOffset, dstSize, sourceArr, srcOffset, srcSize);
    }

    public static int recommendedTargetBufferSize() {
        return (int)ZstdBufferDecompressingStreamNoFinalizer.recommendedDOutSizeNative();
    }

    private native long createDStreamNative();

    private native long freeDStreamNative(long var1);

    private native long initDStreamNative(long var1);

    private native long decompressStreamNative(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8);

    private static native long recommendedDOutSizeNative();

    static {
        Native.load();
    }
}

