/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.NoPool;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.ZstdIOException;
import com.github.luben.zstd.util.Native;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ZstdInputStreamNoFinalizer
extends FilterInputStream {
    private final long stream;
    private long dstPos = 0L;
    private long srcPos = 0L;
    private long srcSize = 0L;
    private boolean needRead = true;
    private final BufferPool bufferPool;
    private final ByteBuffer srcByteBuffer;
    private final byte[] src;
    private static final int srcBuffSize;
    private boolean isContinuous = false;
    private boolean frameFinished = true;
    private boolean isClosed = false;

    public static native long recommendedDInSize();

    public static native long recommendedDOutSize();

    private static native long createDStream();

    private static native int freeDStream(long var0);

    private native int initDStream(long var1);

    private native int decompressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    public ZstdInputStreamNoFinalizer(InputStream inStream) throws IOException {
        this(inStream, NoPool.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdInputStreamNoFinalizer(InputStream inStream, BufferPool bufferPool) throws IOException {
        super(inStream);
        this.bufferPool = bufferPool;
        this.srcByteBuffer = bufferPool.get(srcBuffSize);
        if (this.srcByteBuffer == null) {
            throw new ZstdIOException(Zstd.errMemoryAllocation(), "Cannot get ByteBuffer of size " + srcBuffSize + " from the BufferPool");
        }
        this.src = Zstd.extractArray(this.srcByteBuffer);
        ZstdInputStreamNoFinalizer zstdInputStreamNoFinalizer = this;
        synchronized (zstdInputStreamNoFinalizer) {
            this.stream = ZstdInputStreamNoFinalizer.createDStream();
            this.initDStream(this.stream);
        }
    }

    public synchronized ZstdInputStreamNoFinalizer setContinuous(boolean b) {
        this.isContinuous = b;
        return this;
    }

    public synchronized boolean getContinuous() {
        return this.isContinuous;
    }

    public synchronized ZstdInputStreamNoFinalizer setDict(byte[] dict) throws IOException {
        int size = Zstd.loadDictDecompress(this.stream, dict, dict.length);
        if (Zstd.isError(size)) {
            throw new ZstdIOException(size);
        }
        return this;
    }

    public synchronized ZstdInputStreamNoFinalizer setDict(ZstdDictDecompress dict) throws IOException {
        dict.acquireSharedLock();
        try {
            int size = Zstd.loadFastDictDecompress(this.stream, dict);
            if (Zstd.isError(size)) {
                throw new ZstdIOException(size);
            }
        }
        finally {
            dict.releaseSharedLock();
        }
        return this;
    }

    public synchronized ZstdInputStreamNoFinalizer setLongMax(int windowLogMax) throws IOException {
        int size = Zstd.setDecompressionLongMax(this.stream, windowLogMax);
        if (Zstd.isError(size)) {
            throw new ZstdIOException(size);
        }
        return this;
    }

    public synchronized ZstdInputStreamNoFinalizer setRefMultipleDDicts(boolean useMultiple) throws IOException {
        int size = Zstd.setRefMultipleDDicts(this.stream, useMultiple);
        if (Zstd.isError(size)) {
            throw new ZstdIOException(size);
        }
        return this;
    }

    @Override
    public synchronized int read(byte[] dst, int offset, int len) throws IOException {
        if (offset < 0 || len > dst.length - offset) {
            throw new IndexOutOfBoundsException("Requested length " + len + " from offset " + offset + " in buffer of size " + dst.length);
        }
        if (len == 0) {
            return 0;
        }
        int result = 0;
        while (result == 0) {
            result = this.readInternal(dst, offset, len);
        }
        return result;
    }

    int readInternal(byte[] dst, int offset, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (offset < 0 || len > dst.length - offset) {
            throw new IndexOutOfBoundsException("Requested length " + len + " from offset " + offset + " in buffer of size " + dst.length);
        }
        int dstSize = offset + len;
        this.dstPos = offset;
        long lastDstPos = -1L;
        while (this.dstPos < (long)dstSize && lastDstPos < this.dstPos) {
            if (this.needRead && (this.in.available() > 0 || this.dstPos == (long)offset)) {
                this.srcSize = this.in.read(this.src, 0, srcBuffSize);
                this.srcPos = 0L;
                if (this.srcSize < 0L) {
                    this.srcSize = 0L;
                    if (this.frameFinished) {
                        return -1;
                    }
                    if (this.isContinuous) {
                        this.srcSize = (int)(this.dstPos - (long)offset);
                        if (this.srcSize > 0L) {
                            return (int)this.srcSize;
                        }
                        return -1;
                    }
                    throw new ZstdIOException(Zstd.errCorruptionDetected(), "Truncated source");
                }
                this.frameFinished = false;
            }
            lastDstPos = this.dstPos;
            int size = this.decompressStream(this.stream, dst, dstSize, this.src, (int)this.srcSize);
            if (Zstd.isError(size)) {
                throw new ZstdIOException(size);
            }
            if (size == 0) {
                this.frameFinished = true;
                this.needRead = this.srcPos == this.srcSize;
                return (int)(this.dstPos - (long)offset);
            }
            this.needRead = this.dstPos < (long)dstSize;
        }
        return (int)(this.dstPos - (long)offset);
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] oneByte = new byte[1];
        int result = 0;
        while (result == 0) {
            result = this.readInternal(oneByte, 0, 1);
        }
        if (result == 1) {
            return oneByte[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (!this.needRead) {
            return 1;
        }
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long skip(long numBytes) throws IOException {
        long toSkip;
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (numBytes <= 0L) {
            return 0L;
        }
        int bufferLen = (int)ZstdInputStreamNoFinalizer.recommendedDOutSize();
        if ((long)bufferLen > numBytes) {
            bufferLen = (int)numBytes;
        }
        ByteBuffer buf = this.bufferPool.get(bufferLen);
        try {
            int read;
            byte[] data = Zstd.extractArray(buf);
            for (toSkip = numBytes; toSkip > 0L; toSkip -= (long)read) {
                read = this.read(data, 0, (int)Math.min((long)bufferLen, toSkip));
                if (read >= 0) continue;
                break;
            }
        }
        finally {
            this.bufferPool.release(buf);
        }
        return numBytes - toSkip;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.bufferPool.release(this.srcByteBuffer);
        ZstdInputStreamNoFinalizer.freeDStream(this.stream);
        this.in.close();
    }

    static {
        Native.load();
        srcBuffSize = (int)ZstdInputStreamNoFinalizer.recommendedDInSize();
    }
}

