/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.AutoCloseBase;
import com.github.luben.zstd.Objects;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ZstdDecompressCtx
extends AutoCloseBase {
    private long nativePtr = ZstdDecompressCtx.init();
    private ZstdDictDecompress decompression_dict = null;

    private static native long init();

    private static native void free(long var0);

    public ZstdDecompressCtx() {
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createDeCompressCtx failed");
        }
        this.storeFence();
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            ZstdDecompressCtx.free(this.nativePtr);
            this.nativePtr = 0L;
        }
    }

    public ZstdDecompressCtx setMagicless(boolean magiclessFlag) {
        this.ensureOpen();
        this.acquireSharedLock();
        Zstd.setDecompressionMagicless(this.nativePtr, magiclessFlag);
        this.releaseSharedLock();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdDecompressCtx loadDict(ZstdDictDecompress dict) {
        this.ensureOpen();
        this.acquireSharedLock();
        dict.acquireSharedLock();
        try {
            long result = ZstdDecompressCtx.loadDDictFast0(this.nativePtr, dict);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            this.decompression_dict = dict;
        }
        finally {
            dict.releaseSharedLock();
            this.releaseSharedLock();
        }
        return this;
    }

    private static native long loadDDictFast0(long var0, ZstdDictDecompress var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdDecompressCtx loadDict(byte[] dict) {
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long result = ZstdDecompressCtx.loadDDict0(this.nativePtr, dict);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            this.decompression_dict = null;
        }
        finally {
            this.releaseSharedLock();
        }
        return this;
    }

    private static native long loadDDict0(long var0, byte[] var2);

    public void reset() {
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long result = ZstdDecompressCtx.reset0(this.nativePtr);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long reset0(long var0);

    private void ensureOpen() {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Decompression context is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decompressDirectByteBufferStream(ByteBuffer dst, ByteBuffer src) {
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long result = ZstdDecompressCtx.decompressDirectByteBufferStream0(this.nativePtr, dst, dst.position(), dst.limit(), src, src.position(), src.limit());
            if ((result & 0x80000000L) != 0L) {
                long code = result & 0xFFL;
                throw new ZstdException(code, Zstd.getErrorName(code));
            }
            src.position((int)(result & Integer.MAX_VALUE));
            dst.position((int)(result >>> 32) & Integer.MAX_VALUE);
            boolean bl = result >>> 63 == 1L;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long decompressDirectByteBufferStream0(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decompressDirectByteBuffer(ByteBuffer dstBuff, int dstOffset, int dstSize, ByteBuffer srcBuff, int srcOffset, int srcSize) {
        this.ensureOpen();
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!dstBuff.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        Objects.checkFromIndexSize(srcOffset, srcSize, srcBuff.limit());
        Objects.checkFromIndexSize(dstOffset, dstSize, dstBuff.limit());
        this.acquireSharedLock();
        try {
            long size = ZstdDecompressCtx.decompressDirectByteBuffer0(this.nativePtr, dstBuff, dstOffset, dstSize, srcBuff, srcOffset, srcSize);
            if (Zstd.isError(size)) {
                throw new ZstdException(size);
            }
            if (size > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)size;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long decompressDirectByteBuffer0(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decompressByteArray(byte[] dstBuff, int dstOffset, int dstSize, byte[] srcBuff, int srcOffset, int srcSize) {
        Objects.checkFromIndexSize(srcOffset, srcSize, srcBuff.length);
        Objects.checkFromIndexSize(dstOffset, dstSize, dstBuff.length);
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long size = ZstdDecompressCtx.decompressByteArray0(this.nativePtr, dstBuff, dstOffset, dstSize, srcBuff, srcOffset, srcSize);
            if (Zstd.isError(size)) {
                throw new ZstdException(size);
            }
            if (size > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)size;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long decompressByteArray0(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decompressByteArrayToDirectByteBuffer(ByteBuffer dstBuff, int dstOffset, int dstSize, byte[] srcBuff, int srcOffset, int srcSize) {
        if (!dstBuff.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        Objects.checkFromIndexSize(srcOffset, srcSize, srcBuff.length);
        Objects.checkFromIndexSize(dstOffset, dstSize, dstBuff.limit());
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long size = ZstdDecompressCtx.decompressByteArrayToDirectByteBuffer0(this.nativePtr, dstBuff, dstOffset, dstSize, srcBuff, srcOffset, srcSize);
            if (Zstd.isError(size)) {
                throw new ZstdException(size);
            }
            if (size > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)size;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long decompressByteArrayToDirectByteBuffer0(long var0, ByteBuffer var2, int var3, int var4, byte[] var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decompressDirectByteBufferToByteArray(byte[] dstBuff, int dstOffset, int dstSize, ByteBuffer srcBuff, int srcOffset, int srcSize) {
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        Objects.checkFromIndexSize(srcOffset, srcSize, srcBuff.limit());
        Objects.checkFromIndexSize(dstOffset, dstSize, dstBuff.length);
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long size = ZstdDecompressCtx.decompressDirectByteBufferToByteArray0(this.nativePtr, dstBuff, dstOffset, dstSize, srcBuff, srcOffset, srcSize);
            if (Zstd.isError(size)) {
                throw new ZstdException(size);
            }
            if (size > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)size;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long decompressDirectByteBufferToByteArray0(long var0, byte[] var2, int var3, int var4, ByteBuffer var5, int var6, int var7);

    public int decompress(ByteBuffer dstBuf, ByteBuffer srcBuf) throws ZstdException {
        int size = this.decompressDirectByteBuffer(dstBuf, dstBuf.position(), dstBuf.limit() - dstBuf.position(), srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position());
        srcBuf.position(srcBuf.limit());
        dstBuf.position(dstBuf.position() + size);
        return size;
    }

    public int decompress(ByteBuffer dstBuf, byte[] src) throws ZstdException {
        int size = this.decompressByteArrayToDirectByteBuffer(dstBuf, dstBuf.position(), dstBuf.limit() - dstBuf.position(), src, 0, src.length);
        dstBuf.position(dstBuf.position() + size);
        return size;
    }

    public int decompress(byte[] dst, ByteBuffer srcBuf) throws ZstdException {
        int size = this.decompressDirectByteBufferToByteArray(dst, 0, dst.length, srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position());
        srcBuf.position(srcBuf.limit());
        return size;
    }

    public ByteBuffer decompress(ByteBuffer srcBuf, int originalSize) throws ZstdException {
        ByteBuffer dstBuf = ByteBuffer.allocateDirect(originalSize);
        int size = this.decompressDirectByteBuffer(dstBuf, 0, originalSize, srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position());
        srcBuf.position(srcBuf.limit());
        return dstBuf;
    }

    public int decompress(byte[] dst, byte[] src) {
        return this.decompressByteArray(dst, 0, dst.length, src, 0, src.length);
    }

    public byte[] decompress(byte[] src, int originalSize) throws ZstdException {
        return this.decompress(src, 0, src.length, originalSize);
    }

    public byte[] decompress(byte[] src, int srcOffset, int srcSize, int originalSize) throws ZstdException {
        if (originalSize < 0) {
            throw new ZstdException(Zstd.errGeneric(), "Original size should not be negative");
        }
        byte[] dst = new byte[originalSize];
        int size = this.decompressByteArray(dst, 0, dst.length, src, srcOffset, srcSize);
        if (size != originalSize) {
            return Arrays.copyOfRange(dst, 0, size);
        }
        return dst;
    }

    static {
        Native.load();
    }
}

