/*
 * Decompiled with CFR 0.152.
 */
package com.lib.spref;

import android.content.Context;
import com.lib.spref.SettingsConnector;
import com.lib.spref.Utils.EncryptionUtils;

public class SPref {
    private static SPref sInstance;
    private static byte[] mEncryptSeed;
    private static SettingsConnector mSettingsConnector;
    private String mPreferencesName;
    private Context mContext;
    private int mResource = -1;
    private int mMode = -1;
    private boolean mShouldOverride;

    private SPref(Context context) {
        this.mContext = context;
    }

    private SPref() {
    }

    public static SPref init(Context context) {
        sInstance = new SPref(context);
        return sInstance;
    }

    public SPref name(String preferencesName) {
        this.mPreferencesName = preferencesName;
        return sInstance;
    }

    protected Context getApplicationContext() {
        return this.mContext;
    }

    @Deprecated
    public SPref provideDefaultResourceFile(int resource) {
        this.mResource = resource;
        this.mShouldOverride = false;
        return sInstance;
    }

    public SPref provideDefaultResourceFile(int resource, boolean shouldOverride) {
        this.mResource = resource;
        this.mShouldOverride = shouldOverride;
        return sInstance;
    }

    public SPref encrypt(byte[] key) {
        mEncryptSeed = key;
        return sInstance;
    }

    public SPref encrypt(String key) {
        mEncryptSeed = EncryptionUtils.generateKey(key);
        return sInstance;
    }

    public SPref mode(int mode) {
        this.mMode = mode;
        return sInstance;
    }

    public SettingsConnector buildSettings() {
        return new SettingsConnector(this.getApplicationContext(), this.mResource, this.mPreferencesName, mEncryptSeed, this.mShouldOverride, this.mMode);
    }

    public static SettingsConnector buildSettings(Context context) {
        mSettingsConnector = new SettingsConnector(context, -1, null, mEncryptSeed, false, -1);
        return mSettingsConnector;
    }

    static {
        mEncryptSeed = null;
    }
}

