/*
 * Decompiled with CFR 0.152.
 */
package com.lib.spref;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.lib.spref.Utils.EncryptionUtils;
import com.lib.spref.Utils.MergeUtils;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SettingsConnector {
    private static final String SHARED_PREF_NAME = "sp_settings";
    private final SharedPreferences mPreferences;
    private final byte[] mEncrypt;

    public SettingsConnector(Context context, int resource, String preferencesName, byte[] encrypt, boolean shouldOverride, int mode) {
        this.mPreferences = context.getSharedPreferences(TextUtils.isEmpty((CharSequence)preferencesName) ? SHARED_PREF_NAME : preferencesName, mode == -1 ? 0 : mode);
        this.mEncrypt = encrypt;
        if (resource != -1) {
            MergeUtils.merge(context, resource, this.mPreferences, shouldOverride);
        }
    }

    public String getSetting(String settingKey) {
        if (settingKey == null) {
            return null;
        }
        return this.mPreferences.getString(settingKey, null);
    }

    public String getEncryptedSetting(String settingKey) {
        String value = this.mPreferences.getString(settingKey, null);
        if (this.mEncrypt != null && !TextUtils.isEmpty((CharSequence)value)) {
            byte[] array = Base64.decode((String)value, (int)2);
            return EncryptionUtils.decrypt(this.mEncrypt, array);
        }
        return null;
    }

    public int getIntSetting(String settingKey) {
        if (settingKey == null) {
            return -1;
        }
        return this.mPreferences.getInt(settingKey, -1);
    }

    public float getFloatSetting(String settingKey) {
        if (settingKey == null) {
            return -1.0f;
        }
        return this.mPreferences.getFloat(settingKey, -1.0f);
    }

    public long getLongSetting(String settingKey) {
        if (settingKey == null) {
            return -1L;
        }
        return this.mPreferences.getLong(settingKey, -1L);
    }

    public boolean getBooleanSetting(String settingKey, boolean defaultValue) {
        if (settingKey == null) {
            return defaultValue;
        }
        return this.mPreferences.getBoolean(settingKey, defaultValue);
    }

    public <T> List<T> getListSetting(String settingKey) {
        Gson gson = new Gson();
        Type listType = new TypeToken<ArrayList<T>>(){}.getType();
        return (List)gson.fromJson(this.getSetting(settingKey), listType);
    }

    public void saveSetting(String settingKey, String settingValue) {
        this.mPreferences.edit().putString(settingKey, settingValue).apply();
    }

    public void saveEncryptedSetting(String settingKey, String settingValue) {
        if (this.mEncrypt != null && settingValue != null) {
            byte[] resultValue = EncryptionUtils.encrypt(this.mEncrypt, settingValue);
            settingValue = Base64.encodeToString((byte[])resultValue, (int)2);
        } else {
            settingValue = null;
        }
        this.mPreferences.edit().putString(settingKey, settingValue).apply();
    }

    public void saveSetting(String settingKey, boolean settingValue) {
        this.mPreferences.edit().putBoolean(settingKey, settingValue).apply();
    }

    public void saveSetting(String settingKey, Integer settingValue) {
        if (settingValue == null) {
            this.mPreferences.edit().putString(settingKey, null).apply();
        } else {
            this.mPreferences.edit().putInt(settingKey, settingValue.intValue()).apply();
        }
    }

    public void saveSetting(String settingKey, Long settingValue) {
        if (settingValue == null) {
            this.mPreferences.edit().putString(settingKey, null).apply();
        } else {
            this.mPreferences.edit().putLong(settingKey, settingValue.longValue()).apply();
        }
    }

    public void saveSetting(String settingKey, Float settingValue) {
        if (settingValue == null) {
            this.mPreferences.edit().putString(settingKey, null).apply();
        } else {
            this.mPreferences.edit().putFloat(settingKey, settingValue.floatValue()).apply();
        }
    }

    public <T> void saveSetting(String settingKey, List<T> settingValue) {
        Gson gson = new Gson();
        this.saveSetting(settingKey, gson.toJson(settingValue));
    }

    public void saveSetting(String settingKey, Set<String> settingValue) {
        this.mPreferences.edit().putStringSet(settingKey, settingValue).apply();
    }

    public void removeSetting(String settingKey) {
        if (settingKey != null) {
            this.mPreferences.edit().remove(settingKey).apply();
        }
    }

    public void removeBulkSetting(String ... settingKey) {
        if (settingKey != null) {
            for (String aSettingKey : settingKey) {
                this.removeSetting(aSettingKey);
            }
        }
    }

    public void mergeSettings(File file, boolean shouldOverride) {
        if (file != null && file.exists()) {
            MergeUtils.merge(file, this.mPreferences, shouldOverride);
        }
    }

    public void removeAllSetting() {
        this.mPreferences.edit().clear().apply();
    }
}

