/*
 * Decompiled with CFR 0.152.
 */
package com.lib.spref.Utils;

import com.lib.spref.Utils.ByteUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtils {
    private static final String ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String ALGORITHM_SHA1 = "SHA-1";
    private static final String SECRET_KEY = "AES";
    private static final String STRING_ENCODING = "UTF-8";

    public static byte[] encrypt(byte[] seed, String clearMessage) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(seed, SECRET_KEY);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, secretKey);
            return cipher.doFinal(ByteUtils.getByteArray(clearMessage));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String decrypt(byte[] seed, byte[] content) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            SecretKeySpec secretKey = new SecretKeySpec(seed, SECRET_KEY);
            cipher.init(2, secretKey);
            byte[] decrypted = cipher.doFinal(content);
            if (decrypted == null) {
                return null;
            }
            return new String(decrypted, STRING_ENCODING);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            return null;
        }
    }

    public static byte[] generateKey(String value) {
        try {
            byte[] key = value.getBytes(STRING_ENCODING);
            MessageDigest sha = MessageDigest.getInstance(ALGORITHM_SHA1);
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, SECRET_KEY);
            return secretKeySpec.getEncoded();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            return null;
        }
    }
}

