/*
 * Decompiled with CFR 0.152.
 */
package com.lib.spref.Utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.sax.Element;
import android.sax.RootElement;
import android.sax.TextElementListener;
import android.util.Xml;
import com.lib.spref.internal.CustomTextElementListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;

public class MergeUtils {
    public static final String DEFAULT_FILE_ATTR_NAME = "name";
    private static final String DEFAULT_FILE_DEFAULT_ELEMENT = "default";
    private static final String DEFAULT_FILE_STRING_ELEMENT = "string";
    private static final String DEFAULT_FILE_INTEGER_ELEMENT = "integer";
    private static final String DEFAULT_FILE_FLOAT_ELEMENT = "float";
    private static final String DEFAULT_FILE_LONG_ELEMENT = "long";

    public static void merge(Context context, int resource, SharedPreferences preferences, boolean shouldOverride) {
        MergeUtils.mergeWithLocalFile(context.getResources().openRawResource(resource), preferences, shouldOverride);
    }

    public static void merge(File file, SharedPreferences preferences, boolean shouldOverride) {
        try {
            MergeUtils.mergeWithLocalFile(new FileInputStream(file), preferences, shouldOverride);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mergeWithLocalFile(InputStream defaultLanguageFileStream, SharedPreferences preferences, boolean shouldOverride) {
        try {
            RootElement rootElement = new RootElement(DEFAULT_FILE_DEFAULT_ELEMENT);
            Element textElement = rootElement.getChild(DEFAULT_FILE_STRING_ELEMENT);
            Element integerElement = rootElement.getChild(DEFAULT_FILE_INTEGER_ELEMENT);
            Element floatElement = rootElement.getChild(DEFAULT_FILE_FLOAT_ELEMENT);
            Element longElement = rootElement.getChild(DEFAULT_FILE_LONG_ELEMENT);
            final HashMap<String, String> stringsToAdd = new HashMap<String, String>();
            final HashMap<String, Integer> integerToAdd = new HashMap<String, Integer>();
            final HashMap<String, Float> floatToAdd = new HashMap<String, Float>();
            final HashMap<String, Long> longToAdd = new HashMap<String, Long>();
            textElement.setTextElementListener((TextElementListener)new CustomTextElementListener(preferences, shouldOverride){

                @Override
                public void addValue(String key, String value) {
                    try {
                        stringsToAdd.put(key, value);
                    }
                    catch (Exception e) {
                        stringsToAdd.put(key, null);
                    }
                }
            });
            floatElement.setTextElementListener((TextElementListener)new CustomTextElementListener(preferences, shouldOverride){

                @Override
                public void addValue(String key, String value) {
                    try {
                        floatToAdd.put(key, Float.valueOf(value));
                    }
                    catch (Exception e) {
                        floatToAdd.put(key, Float.valueOf(-1.0f));
                    }
                }
            });
            integerElement.setTextElementListener((TextElementListener)new CustomTextElementListener(preferences, shouldOverride){

                @Override
                public void addValue(String key, String value) {
                    try {
                        integerToAdd.put(key, Integer.valueOf(value));
                    }
                    catch (Exception e) {
                        integerToAdd.put(key, -1);
                    }
                }
            });
            longElement.setTextElementListener((TextElementListener)new CustomTextElementListener(preferences, shouldOverride){

                @Override
                public void addValue(String key, String value) {
                    try {
                        longToAdd.put(key, Long.valueOf(value));
                    }
                    catch (Exception e) {
                        longToAdd.put(key, -1L);
                    }
                }
            });
            Xml.parse((InputStream)defaultLanguageFileStream, (Xml.Encoding)Xml.Encoding.UTF_8, (ContentHandler)rootElement.getContentHandler());
            if (!stringsToAdd.isEmpty()) {
                MergeUtils.save(preferences, stringsToAdd);
            }
            if (!integerToAdd.isEmpty()) {
                MergeUtils.saveInt(preferences, integerToAdd);
            }
            if (!floatToAdd.isEmpty()) {
                MergeUtils.saveFloat(preferences, floatToAdd);
            }
            if (!longToAdd.isEmpty()) {
                MergeUtils.saveLong(preferences, longToAdd);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (defaultLanguageFileStream != null) {
                    defaultLanguageFileStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static void save(SharedPreferences preferences, Map<String, String> keysValues) {
        SharedPreferences.Editor editor = preferences.edit();
        for (Map.Entry<String, String> entry : keysValues.entrySet()) {
            editor.putString(entry.getKey(), entry.getValue());
        }
        editor.apply();
    }

    static void saveInt(SharedPreferences preferences, Map<String, Integer> keysValues) {
        SharedPreferences.Editor editor = preferences.edit();
        for (Map.Entry<String, Integer> entry : keysValues.entrySet()) {
            editor.putInt(entry.getKey(), entry.getValue().intValue());
        }
        editor.apply();
    }

    static void saveFloat(SharedPreferences preferences, Map<String, Float> keysValues) {
        SharedPreferences.Editor editor = preferences.edit();
        for (Map.Entry<String, Float> entry : keysValues.entrySet()) {
            editor.putFloat(entry.getKey(), entry.getValue().floatValue());
        }
        editor.apply();
    }

    static void saveLong(SharedPreferences preferences, Map<String, Long> keysValues) {
        SharedPreferences.Editor editor = preferences.edit();
        for (Map.Entry<String, Long> entry : keysValues.entrySet()) {
            editor.putLong(entry.getKey(), entry.getValue().longValue());
        }
        editor.apply();
    }
}

