/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.core;

import com.luues.openoffice.core.StandardConversionTask;
import com.luues.openoffice.core.document.DefaultDocumentFormatRegistry;
import com.luues.openoffice.core.document.DocumentFormat;
import com.luues.openoffice.core.document.DocumentFormatRegistry;
import com.luues.openoffice.core.office.OfficeException;
import com.luues.openoffice.core.office.OfficeManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class OfficeDocumentConverter {
    private final OfficeManager officeManager;
    private final DocumentFormatRegistry formatRegistry;
    private Map<String, ?> defaultLoadProperties = this.createDefaultLoadProperties();

    public OfficeDocumentConverter(OfficeManager officeManager) {
        this(officeManager, new DefaultDocumentFormatRegistry());
    }

    public OfficeDocumentConverter(OfficeManager officeManager, DocumentFormatRegistry formatRegistry) {
        this.officeManager = officeManager;
        this.formatRegistry = formatRegistry;
    }

    private Map<String, Object> createDefaultLoadProperties() {
        HashMap<String, Object> loadProperties = new HashMap<String, Object>();
        loadProperties.put("Hidden", true);
        loadProperties.put("ReadOnly", true);
        loadProperties.put("UpdateDocMode", (short)1);
        return loadProperties;
    }

    public void setDefaultLoadProperties(Map<String, ?> defaultLoadProperties) {
        this.defaultLoadProperties = defaultLoadProperties;
    }

    public DocumentFormatRegistry getFormatRegistry() {
        return this.formatRegistry;
    }

    public void convert(File inputFile, File outputFile) throws OfficeException {
        String outputExtension = FilenameUtils.getExtension((String)outputFile.getName());
        DocumentFormat outputFormat = this.formatRegistry.getFormatByExtension(outputExtension);
        this.convert(inputFile, outputFile, outputFormat);
    }

    public void convert(File inputFile, File outputFile, DocumentFormat outputFormat) throws OfficeException {
        String inputExtension = FilenameUtils.getExtension((String)inputFile.getName());
        DocumentFormat inputFormat = this.formatRegistry.getFormatByExtension(inputExtension);
        StandardConversionTask conversionTask = new StandardConversionTask(inputFile, outputFile, outputFormat);
        conversionTask.setDefaultLoadProperties(this.defaultLoadProperties);
        conversionTask.setInputFormat(inputFormat);
        this.officeManager.execute(conversionTask);
    }
}

